<?php
require_once 'conn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

header('Content-Type: application/json');

function sendVerificationSuccessEmail($email, $name) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($email, $name);
        $mail->isHTML(true);
        $mail->Subject = 'Email Verified Successfully - Errandly';
        $mail->Body = "Hi $name,<br><br>Your email address has been successfully verified.<br><br>Welcome to Errandly!";

        $mail->send();
        return true;
    } catch (Exception $e) {
        return false;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (!isset($data['email'], $data['otp'])) {
        echo json_encode(['status' => 'error', 'message' => 'Email and OTP are required.']);
        exit();
    }

    $email = mysqli_real_escape_string($con, $data['email']);
    $otp = mysqli_real_escape_string($con, $data['otp']);

    // Fetch user by email
    $result = $con->query("SELECT * FROM users WHERE email = '$email'");

    if ($result && $result->num_rows === 1) {
        $user = $result->fetch_assoc();

        if ($user['otp'] === $otp) {
            $update = $con->query("UPDATE users SET is_verified = '1', otp = '' WHERE email = '$email'");

            if ($update) {
                sendVerificationSuccessEmail($email, $user['name']);

                $responseUser = [
                    'id' => $user['id'],
                    'user_id' => $user['user_id'],
                    'name' => $user['name'],
                    'email' => $user['email'],
                    'phone' => $user['phone'],
                    'image' => 'https://errandly.org/errandly/uploads/user/' . ($user['user_image'] ?: 'placeholder.png'),
                    'wallet' => $user['wallet'],
                    'role' => $user['role'],
                    'status' => $user['status'],
                    'address' => $user['address'],
                    'dob' => $user['dob'],
                    'kyc_status' => $user['kyc_status'],
                    'kyc_submitted' => $user['kyc_submitted'],
                    'acct_name' => $user['acct_name'],
                    'acct_num' => $user['acct_num'],
                    'is_verified' => $user['is_verified']
                ];

                echo json_encode([
                    'status' => 'success',
                    'message' => 'Email verified successfully.',
                    'user' => $responseUser
                ]);
            } else {
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Failed to update verification status.']);
            }
        } else {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'Incorrect OTP.']);
        }
    } else {
        http_response_code(404);
        echo json_encode(['status' => 'error', 'message' => 'User not found.']);
    }
} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>
