<?php
require_once 'conn.php';
header('Content-Type: application/json');

// 1. Check request method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// 2. Check Authorization token
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing or invalid.']);
    exit();
}
$token = $matches[1];

// 3. Parse body
$data = json_decode(file_get_contents("php://input"), true);

// 4. Validate input
if (empty($data['user_id']) || empty($data['otp'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'User ID and OTP are required.']);
    exit();
}

$user_id = mysqli_real_escape_string($con, $data['user_id']);
$otp = mysqli_real_escape_string($con, $data['otp']);

// 5. Fetch user by user_id and validate token
$userQuery = $con->query("SELECT * FROM users WHERE user_id = '$user_id'");
if (!$userQuery || $userQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid user ID.']);
    exit();
}

$user = $userQuery->fetch_assoc();

// 6. Check OTP
if ($user['otp'] !== $otp) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid OTP.']);
    exit();
}

// 7. Check if temp_email exists
if (empty($user['temp_email'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'No email change requested.']);
    exit();
}

$newEmail = $user['temp_email'];

// 8. Check if new email already exists for another user
$checkEmail = $con->query("SELECT * FROM users WHERE email = '$newEmail' AND user_id != '$user_id'");
if ($checkEmail && $checkEmail->num_rows > 0) {
    http_response_code(409);
    echo json_encode(['status' => 'error', 'message' => 'New email already in use.']);
    exit();
}

// 9. Update email, clear temp_email & otp, and set is_verified = 1
$update = $con->query("
    UPDATE users 
    SET email = '$newEmail', temp_email = NULL, otp = NULL, is_verified = '1' 
    WHERE user_id = '$user_id'
");

if ($update) {
    // Fetch updated user data
    $userInfoQuery = $con->query("SELECT * FROM users WHERE user_id = '$user_id'");
    $updatedUser = $userInfoQuery->fetch_assoc();

    $imageUrl = 'https://errandly.org/errandly/uploads/user/' . ($updatedUser['user_image'] ?: 'placeholder.png');

    $userData = [
    'id' => $updatedUser['id'],
    'user_id' => $updatedUser['user_id'],
    'name' => $updatedUser['name'],
    'email' => $updatedUser['email'],
    'phone' => $updatedUser['phone'],
    'wallet' => $updatedUser['wallet'],
    'role' => $updatedUser['role'],
    'status' => $updatedUser['status'],
    'dob' => $updatedUser['dob'] ?? '',
    'address' => $updatedUser['address'] ?? '',
    'is_verified' => $updatedUser['is_verified'],
    'user_image' => $imageUrl,
    'kyc_status' => $updatedUser['kyc_status'] ?? '',
    'kyc_submitted' => $updatedUser['kyc_submitted'] ?? '',
    'acct_name' => $updatedUser['acct_name'] ?? '',
    'acct_num' => $updatedUser['acct_num'] ?? '',
];


    echo json_encode([
        'status' => 'success',
        'message' => 'Email updated and verified successfully.',
        'user' => $userData
    ]);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to update email.']);
}
?>
