<?php session_start(); ?>
<?php include 'layout/header.php'; ?>

<title>Register Page</title>

<style>
    .logo-image {
        width: 100px;
        height: auto;
        margin-bottom: 20px;
    }

    .form-control {
        width: 100%;
        margin-bottom: 15px;
    }

    .input-password .form-control {
        padding-right: 50px;
        display: inline-block;
    }

    .input-password .input-group-text {
        position: absolute;
        right: 10px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        border: none;
        background: transparent;
        color: #333;
    }

    .input-group {
        position: relative;
    }

    #register-btn {
        width: 100%;
        max-width: 300px;
        padding: 12px;
        font-size: 1.1rem;
        background-color: #007bff;
        color: #fff;
        border: none;
        border-radius: 5px;
        transition: background-color 0.3s;
    }

    #register-btn:hover {
        background-color: #0056b3;
        cursor: pointer;
    }

    @media (max-width: 576px) {
        .form-control {
            width: 100%;
        }
    }

    .register-btnn:disabled {
        background-color: #ccc !important;
        cursor: not-allowed;
    }

    .register-btnn:enabled {
        background-color: rgba(207, 166, 110, 1) !important;
        cursor: pointer;
    }
</style>

<section class="py-5" style="margin-top:100px;">
    <div class="container text-center mt-3 pt-3">
        <div class="row align-items-center"></div>
    </div>

    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-4 text-center position-relative" style="max-height: 700px; width: 100%;">
                <img src="assets/img/2149871158 1.png" alt="Side Image"
                     class="img-fluid w-100" style="height: 700px; object-fit: cover;">
                <div style="
                    position: absolute;
                    bottom: 0;
                    left: 0;
                    width: 100%;
                    height: 40%;
                    background: linear-gradient(to top, rgba(0, 0, 0, 0.6), transparent);">
                </div>
                <div style="
                    position: absolute;
                    bottom: 15px;
                    left: 50%;
                    transform: translateX(-50%);
                    color: white;
                    text-shadow: 0px 0px 5px rgba(0, 0, 0, 0.7);">
                    <p style="font-weight:500;">Manage your store, orders and growth in one place</p>
                    <p style="font-weight: 400; font-size: 10px;">© 2025 Errandly All rights reserved.</p>
                </div>
            </div>

            <div class="col-lg-8 mt-3">
                <h2 class="" style="color: rgba(20, 20, 42, 1); font-weight:700; font-size: 
                40px; text-align: center; line-height: 56px;">
                    Welcome to Errandly
                </h2>
                <p style="font-size: 15px; text-align: center;">Create your account here</p>

                <form id="registration-form" class="w-100">
                    <?php if (isset($_SESSION['err'])): ?>
                        <div class="error-messages" style="color: red;">
                            <ul>
                                <?php foreach ($_SESSION['err'] as $error): ?>
                                    <li><?php echo $error; ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <?php unset($_SESSION['err']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['success'])): ?>
                        <div class="success-message" style="color: green;">
                            <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
                        </div>
                    <?php endif; ?>

                    <div class="form-group mb-3 my-4">
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <label for="floatingInputFull">Fullname:</label>
                                <div class="input-group">
                                    <input type="text" class="form-control p-2" name="name" id="floatingInputFull" required>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <label for="floatingInputNumber">Call line:</label>
                                <div class="input-group">
                                    <input type="number" class="form-control p-2" name="phone" id="floatingInputNumber" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-3 my-4">
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <label for="floatingInputEmail">Email:</label>
                                <div class="input-group">
                                    <input type="email" class="form-control p-2" name="email" id="floatingInputEmail" required>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <label for="floatingdob">Date of Birth:</label>
                                <div class="input-group">
                                    <input type="date" class="form-control p-2" name="dob" id="floatingdob" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-3 my-4 input-password">
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <label for="register-password">Password</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="register-password" name="password" placeholder="Password" required>
                                    <button class="btn btn-outline-secondary" type="button" style="height: 38px; 
                                    padding: 0.375rem 0.75rem; border-left: none; border-radius: 0 0.375rem 0.375rem
                                     0; border-color: rgba(234, 236, 240, 1);"
                                     onclick="togglePassword('register-password', this)">
                                        <i class="bi bi-eye-slash"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <label for="register-cpassword">Confirm Password</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="register-cpassword" name="cpassword" placeholder="Confirm Password" required>
                                    <button class="btn btn-outline-secondary" type="button" style="height: 38px; 
                                    padding: 0.375rem 0.75rem; border-left: none; border-radius: 0 0.375rem 0.375rem
                                     0; border-color: rgba(234, 236, 240, 1);"
                                    onclick="togglePassword('register-cpassword', this)">
                                        <i class="bi bi-eye-slash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group text-center">
                        <button type="button" class="register-btnn" id="register-btn" disabled>Create Account</button>
                    </div>

                    <div class="form-group text-center">
                        <a href="login.php" style="color:rgba(0, 0, 0, 1); font-size: 16px; text-decoration:none; font-weight: 500;">
                            Already have an account? <strong style="color: rgba(207, 166, 110, 1);">Login</strong>
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    function togglePassword(inputId, button) {
        const input = document.getElementById(inputId);
        const icon = button.querySelector('i');
        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('bi-eye-slash');
            icon.classList.add('bi-eye');
        } else {
            input.type = 'password';
            icon.classList.remove('bi-eye');
            icon.classList.add('bi-eye-slash');
        }
    }

    function allFieldsFilled() {
        let filled = true;
        $('#registration-form input[required]').each(function () {
            if ($(this).val().trim() === '') {
                filled = false;
                return false;
            }
        });
        return filled;
    }

   $(document).ready(function () {

    // Enable/disable the register button based on required inputs
    $('#registration-form input').on('input change', function () {
        $('#register-btn').prop('disabled', !allFieldsFilled());
    });

    // When the register button is clicked
    $('#register-btn').on('click', function () {
        if (!allFieldsFilled()) return;

        // Collect form data
        const formData = {
            name: $('#floatingInputFull').val(),
            phone: $('#floatingInputNumber').val(),
            email: $('#floatingInputEmail').val(),
            password: $('#register-password').val(),
            dob: $('#floatingdob').val()
        };

        // Send AJAX request to register
        $.ajax({
            url: 'https://errandly.org/errandly/reg.php', // Make sure this is the correct endpoint
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(formData),
            success: function (response) {
                // If registration is successful
                if (response.status === 'success') {
                    alert(response.message);

                    // Reset the form
                    $('#registration-form')[0].reset();
                    $('#register-btn').prop('disabled', true);

                    // ✅ Redirect to email verification page
                    window.location.href = 'email_verify_code.php'; // Adjust if your actual file is different
                } else {
                    alert(response.message);
                }
            },
            error: function (xhr) {
                const err = xhr.responseJSON;
                alert(err?.message || 'Something went wrong.');
            }
        });
    });
});

</script>

<?php include 'layout/footer.php'; ?>
