<?php
session_start();
require_once 'conn.php';
require 'vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function sendLoginNotificationEmail($userEmail, $userName) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($userEmail);
        $mail->isHTML(true);
        $mail->Subject = 'Login Notification';
        $mail->Body = "Hi $userName,<br><br>You have successfully logged in to your Errandly account. If this wasn't you, please contact support immediately.";
        $mail->send();
    } catch (Exception $e) {}
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');
    $_SESSION['err'] = [];

    if (empty($email) || empty($password)) {
        $_SESSION['err'][] = "Email and password are required.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $_SESSION['err'][] = "Invalid email format.";
    } else {
        $emailEsc = mysqli_real_escape_string($con, $email);
        $passwordEsc = mysqli_real_escape_string($con, $password);
        $query = $con->query("SELECT * FROM users WHERE email = '$emailEsc' AND password = '$passwordEsc'");

        if ($query && $query->num_rows > 0) {
                $user = $query->fetch_assoc();
            
                $token = bin2hex(random_bytes(32));
                $con->query("UPDATE users SET auth_token = '$token' WHERE id = {$user['id']}");
            
                sendLoginNotificationEmail($user['email'], $user['name']);
            
                // Prepare full user session
                $_SESSION['user'] = [
                    'id' => $user['id'],
                    'user_id' => $user['user_id'],
                    'name' => $user['name'],
                    'email' => $user['email'],
                    'phone' => $user['phone'],
                    'user_image' => $user['user_image'],
                    'password' => $user['password'],
                    'wallet' => $user['wallet'],
                    'role' => $user['role'],
                    'status' => $user['status'],
                    'reset_otp' => $user['reset_otp'],
                    'reset_otp_expiry' => $user['reset_otp_expiry'],
                    'address' => $user['address'],
                    'created_at' => $user['created_at'],
                    'updated_at' => $user['updated_at'],
                    'dob' => $user['dob'],
                    'email_verification_otp' => $user['email_verification_otp'],
                    'is_verified' => $user['is_verified'],
                    'auth_token' => $token,
                    'pwd_reset_otp' => $user['pwd_reset_otp'],
                    'pwd_reset_expiry' => $user['pwd_reset_expiry']
                ];
            
                $_SESSION['success'] = "Login successful!";
                header("Location: dashboard.php");
                exit();
            } else {
            $_SESSION['err'][] = "Invalid email or password.";
        }
    }

    // Redirect to self to show messages
    header("Location: login.php");
    exit();
}
?>

<?php include 'layout/header.php'; ?>

<title>Register Page</title>

<style>
    .logo-image {
        width: 100px;
        height: auto;
        margin-bottom: 20px;
    }

    .form-control {
        width: 100%;
        margin-bottom: 15px;
    }

    .input-password .form-control {
        padding-right: 50px;
        display: inline-block;
    }

    .input-password .input-group-text {
        position: absolute;
        right: 10px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        border: none;
        background: transparent;
        color: #333;
    }

    .input-group {
        position: relative;
    }

    #register-btn {
        width: 100%;
        max-width: 300px;
        padding: 12px;
        font-size: 1.1rem;
        background-color: #007bff;
        color: #fff;
        border: none;
        border-radius: 5px;
        transition: background-color 0.3s;
    }

    #register-btn:hover {
        background-color: #0056b3;
        cursor: pointer;
    }

    @media (max-width: 576px) {
        .form-control {
            width: 100%;
        }
    }

    .register-btnn:disabled {
        background-color: #ccc !important;
        cursor: not-allowed;
    }

    .register-btnn:enabled {
        background-color: rgba(207, 166, 110, 1) !important;
        cursor: pointer;
    }
</style>

<section class="py-5" style="margin-top:100px;">
    <div class="container text-center mt-3 pt-3">
        <div class="row align-items-center"></div>
    </div>

    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-4 text-center position-relative" style="max-height: 700px; width: 100%;">
                <img src="assets/img/2149871158 1.png" alt="Side Image"
                     class="img-fluid w-100" style="height: 700px; object-fit: cover;">
                <div style="
                    position: absolute;
                    bottom: 0;
                    left: 0;
                    width: 100%;
                    height: 40%;
                    background: linear-gradient(to top, rgba(0, 0, 0, 0.6), transparent);">
                </div>
                <div style="
                    position: absolute;
                    bottom: 15px;
                    left: 50%;
                    transform: translateX(-50%);
                    color: white;
                    text-shadow: 0px 0px 5px rgba(0, 0, 0, 0.7);">
                    <p style="font-weight:500;">Manage your store, orders and growth in one place</p>
                    <p style="font-weight: 400; font-size: 10px;">© 2025 Errandly All rights reserved.</p>
                </div>
            </div>

            <div class="col-lg-8 mt-3">
                <h2 class="" style="color: rgba(20, 20, 42, 1); font-weight:700; font-size: 
                40px; text-align: center; line-height: 56px;">
                    Welcome back
                </h2>
                <p style="font-size: 15px; text-align: center;">Log into your account</p>

                <form method="POST" id="registration-form" class="w-100" action="login.php">
                    <?php if (isset($_SESSION['err'])): ?>
                        <div class="error-messages" style="color: red;">
                            <ul>
                                <?php foreach ($_SESSION['err'] as $error): ?>
                                    <li><?php echo $error; ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <?php unset($_SESSION['err']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['success'])): ?>
                        <div class="success-message" style="color: green;">
                            <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
                        </div>
                    <?php endif; ?>

                   

                    <div class="form-group mb-3 my-4">
                        <div class="row">
                            <div class="col">
                                <label for="floatingInputEmail">Email:</label>
                                <div class="input-group">
                                    <input type="email" class="form-control p-2" name="email" id="floatingInputEmail" required>
                                </div>
                            </div>
                            
                        </div>
                    </div>

                    <div class="form-group mb-3 my-4 input-password">
                        <div class="row">
                            <div class="col">
                                <label for="register-password">Password</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="register-password" name="password" placeholder="Password" required>
                                    <button class="btn btn-outline-secondary" type="button" style="height: 38px; 
                                    padding: 0.375rem 0.75rem; border-left: none; border-radius: 0 0.375rem 0.375rem
                                     0; border-color: rgba(234, 236, 240, 1);"
                                     onclick="togglePassword('register-password', this)">
                                        <i class="bi bi-eye-slash"></i>
                                    </button>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    <div class="form-group">
                        <a href="login.php" style="color:rgba(0, 0, 0, 1); font-size: 16px; text-decoration:none; font-weight: 500; text-align: right;">
                            <strong style="color: rgba(207, 166, 110, 1); text-align: right; ">Forgotten Password</strong>
                        </a>
                    </div>

                    <div class="form-group text-center">
                        <button type="submit" class="register-btnn" id="register-btn" disabled>Log In</button>
                    </div>

                    
                </form>
            </div>
        </div>
    </div>
</section>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    function togglePassword(inputId, button) {
        const input = document.getElementById(inputId);
        const icon = button.querySelector('i');
        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('bi-eye-slash');
            icon.classList.add('bi-eye');
        } else {
            input.type = 'password';
            icon.classList.remove('bi-eye');
            icon.classList.add('bi-eye-slash');
        }
    }
</script>
<script>
    function allFieldsFilled() {
        const email = $('#floatingInputEmail').val().trim();
        const password = $('#register-password').val().trim();
        return email !== '' && password !== '';
    }

    $(document).ready(function () {
        $('#registration-form input').on('input change', function () {
            $('#register-btn').prop('disabled', !allFieldsFilled());
        });

        $('#register-btn').on('click', function () {
            if (!allFieldsFilled()) return;
            $('#registration-form').submit(); // Submit the form
        });
    });
</script>


<?php include 'layout/footer.php'; ?>
