<style>
    .navbar {
        background-color: #fff;
        padding: 10px 20px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        width: 100%;
    }

    .nav-icons {
        display: flex;
        align-items: center;
        gap: 50px;
        width: 100%;
        justify-content: space-between;
        padding-bottom: 10px;
    }

    .search-container {
        position: relative;
        width: 300px;
        margin-bottom: 10px;
    }

    .search-bar {
        width: 100%;
        padding: 10px 40px 10px 15px;
        border-radius: 15px;
        border: 1px solid #ccc;
        outline: none;
        font-size: 16px;
    }

    .search-container i {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        color: #888;
        cursor: pointer;
    }

    .grid-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        padding: 20px;
    }

    .grid-item {
        text-align: center;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 8px;
        background: #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .grid-item img {
        display: block;
        width: 137px;
        height: 144px;
        object-fit: cover;
        border-radius: 8px;
        margin: 0 auto;
    }

    @media (max-width: 768px) {
        .search-container {
            width: 100%;
            max-width: 400px;
        }
    }

    @media (max-width: 480px) {
        .search-container {
            width: 100%;
            max-width: 300px;
        }
    }
</style>

<nav class="navbar">
    <div class="nav-icons">
        <a href="topup.php" style="text-decoration: none; color: inherit;">
            <p style="display: inline; font-size: 10px; margin-top:10px;">
                <img src="assets/icon/wallet.png" alt="">
                <span>
                    <?php 
                        if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true && isset($_SESSION['wallet'])) {
                            echo htmlspecialchars($_SESSION['wallet']);
                        } else {
                            echo "N/A";
                        }
                    ?>
                </span>
                <sup style="font-size: 20px; color: green; font-weight: bold; margin-left: 5px;">+</sup>
            </p>
        </a>

        <a href="acct.php">
            <img src="assets/icon/person.png" alt="">
        </a>
    </div>

    <!-- Search Bar -->
    <form class="d-flex mx-auto search-container" action="" method="GET">
        <input type="text" class="search-bar" id="searchInput" name="query" placeholder="Search workers...">
        <button type="submit" style="background: none; border: none;">
            <i class="fa fa-search"></i>
        </button>
    </form>
</nav>

<?php


if (isset($_GET['query']) && !empty($_GET['query'])) {
    $search = trim($_GET['query']);
    $search = "%$search%";

    // Prepare and execute search query
    $stmt = $con->prepare("SELECT * FROM workers WHERE name LIKE ? OR skill LIKE ?");
    $stmt->bind_param("ss", $search, $search);
    $stmt->execute();
    $result = $stmt->get_result();

    // Store search results in session
    $_SESSION['search_results'] = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $_SESSION['search_results'][] = $row;
        }
    } else {
        $_SESSION['search_results'] = "No workers found matching your search.";
    }

    // Redirect to remove the search query from the URL
    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit();
}

// Display search results if available
if (isset($_SESSION['search_results'])) {
    echo '<div class="grid-container">';
    if (is_array($_SESSION['search_results']) && count($_SESSION['search_results']) > 0) {
        foreach ($_SESSION['search_results'] as $row) {
            $imageFile = !empty($row['image']) ? "worker/uploads/worker/" . basename($row['image']) : "placeholder.png";

            echo '<div class="grid-item">';
            echo '<img src="' . htmlspecialchars($imageFile) . '" alt="Worker">';
            echo '<h5>' . htmlspecialchars($row['name']) . '</h5>';
            echo '<p>' . htmlspecialchars($row['skill']) . '</p>';
            echo '<p>₦' . htmlspecialchars($row['book_fee']) . '</p>';
            echo '<a href="worker/single_product.php?id=' . $row['id'] . '"><button class="btn view-btn">View</button></a>';
            echo '</div>';
        }
    } else {
        echo "<p>" . $_SESSION['search_results'] . "</p>";
    }
    echo '</div>';

    // Clear search results from session
    unset($_SESSION['search_results']);
} 
?>


