
    <style>
        .bottom-nav {
            position: fixed;
            height: 74px;
            color: #fff;
            margin-top: 30px;
            bottom: 0;
            left: 0;
            width: 100%;
            background: rgba(12, 155, 48, 1);
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
        }
        .bottom-nav a {
            text-decoration: none;
            color: rgba(255, 255, 255, 1);
            text-align: center;
            flex: 1;
            font-weight: 400;
            line-height: 9.68px;
            font-size: 8px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .bottom-nav a img {
            width: 30px; /* Adjust image size */
            height: 30px;
            margin-bottom: 5px;
        }
        .bottom-nav a.active {
            color: rgba(255, 255, 255, 1);
            font-weight: bold;
        }
                .cart-container {
            position: relative;
            display: inline-block;
        }

        .cart-badge {
            position: absolute;
            top: 0;
            right: 0;
            background: red;
            color: white;
            font-size: 12px;
            font-weight: bold;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        @media (max-width: 768px) {
            .bottom-nav {
                height: 60px;
            }
            .bottom-nav a {
                font-size: 10px;
            }
            .bottom-nav a img {
                width: 25px;
                height: 25px;
            }
        }

        @media (max-width: 480px) {
            .bottom-nav {
                height: 55px;
            }
            .bottom-nav a {
                font-size: 9px;
            }
            .bottom-nav a img {
                width: 22px;
                height: 22px;
            }
        }
    </style>


<?php
    // Get the current page name
    $current_page = basename($_SERVER['PHP_SELF']);

    // Simulating the number of cart items (replace this with your actual cart logic)
    $cartItemCount = isset($_SESSION['cart']) ? count($_SESSION['cart']) : 0;
?>

<!-- Bottom Navigation -->
<div class="bottom-nav">
    <a href="index.php" class="<?= ($current_page == 'index.php') ? 'active' : '' ?>">
        <img src="assets/navimg/vector.png" alt="Home">
        Home
    </a>
    <a href="shop.php" class="<?= ($current_page == 'shop.php') ? 'active' : '' ?>">
        <img src="assets/navimg/apps.png" alt="Shop">
        Shop
    </a>
    <a href="cart.php" class="<?= ($current_page == 'cart.php') ? 'active' : '' ?>">
        <div class="cart-container">
            <img src="assets/navimg/iconshoppingcart.png" alt="Cart">
            <?php if ($cartItemCount > 0): ?>
                <span class="cart-badge"><?= $cartItemCount; ?></span>
            <?php endif; ?>
        </div>
        Cart
    </a>
    <a href="profile.php" class="<?= ($current_page == 'profile.php') ? 'active' : '' ?>">
        <img src="assets/navimg/iconsetting.png" alt="Profile">
        Profile
    </a>
</div>

