<?php
session_start();
?>



<style>
    .logo-image {
        height: auto;
        margin-bottom: 90px;
    }
    /* General input styling */
    .form-control {
        width: 100%; /* Make inputs take full width */
        margin-bottom: 15px;
    }
    .input-password .form-control {
        padding-right: 50px; /* Make space for the icon */
        display: inline-block;
    }
    .input-password .input-group-text {
        position: absolute;
        right: 10px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        border: none;
        background: transparent;
        color: #333;
    }
    .input-group {
        position: relative;
    }
    /* OTP input style */
    .otp-input {
        text-align: center;
        font-size: 1.5rem;
        width: 70px !important;
        height: 90px !important; /* Increased height */
        margin: 0 5px;
        border: 1px solid #ccc;
        border-radius: 12px !important;
    }
    .otp-input:focus {
        border: 1px solid #34B433 !important;
        background: rgba(52, 180, 51, 0.18);
        outline: none !important;
        box-shadow: none !important;
    }
    /* Button styling */
    #register-btn {
        width: 100%;
        max-width: 300px;
        padding: 12px;
        font-size: 1.1rem;
        background-color: #007bff;
        color: #fff;
        border: none;
        border-radius: 5px;
        transition: background-color 0.3s;
    }
    #register-btn:hover {
        background-color: #0056b3;
        cursor: pointer;
    }
</style>

<?php include 'layout/header.php'; ?>

<title>Verify OTP</title>

<!-- Register -->
<section class="py-5" style="margin-top:100px;">
    <div class="container text-center mt-3 pt-3">
        <div class="row align-items-center">
            
            <!-- Welcome Text -->
           
        </div>
        <!-- Logo -->
        <div class="col-auto">
                <p style="font-weight:700; line-height: 26px; font-size: 20px; text-align: center;">Errandly</p>
            </div>
        <div class="col">
                <h2 class="roboto-bold" 
                style="color: rgba(207, 166, 110, 1); font-size: 25px; font-weight: 700; f
                ">Verify your Email</h2>
                <p class="roboto-medium">we’ve sent a 6-digit code to <strong><?php echo $_SESSION['email'] ?? 'your email'; ?></strong>.</p>

        </div>
    </div>

    <div class="container">
        <?php if (isset($_SESSION['err'])): ?>
            <div class="error-messages" style="color: red;">
                <?php
                echo $_SESSION['err']; // Display error message
                unset($_SESSION['err']); // Clear the message after displaying
                ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="success-message" style="color: green;">
                <?php
                echo $_SESSION['success']; // Display success message
                unset($_SESSION['success']); // Clear the message after displaying
                ?>
            </div>
        <?php endif; ?>
        <form id="otp-form" class="w-100">
            <div id="error-container" class="error-messages" style="color: red;"></div>
            <div id="success-container" class="success-messages" style="color: green;"></div>

            <!-- OTP Inputs -->
            <div class="form-group mb-3 my-4">
                <div class="row">
                    <div class="col">
                        <label for="floatingInputOtp" class="roboto-medium" style="color:#000000 ; line-height:16px;">Enter OTP</label>
                        <div class="input-group">
                        <input type="text" class="form-control  p-2" name="otp" id="floatingInputOtp">

                        </div>
                    </div>
                    
                </div>
                
            </div>

            <div class="form-group text-center"> 
                <p>Didn’t receive a code? <span style="color:#5ACF59;" id="countdown">15</span> <button type="button" id="resend-btn" class="btn btn-secondary" disabled>
                    Resend</button></p>
                <p>Wrong email? <a href="register.php" style="text-decoration: none; color:rgba(207, 166, 110, 1);">Click to change Email</a></p> 
            </div>
            <div class="form-group text-center"> 
                <button type="submit" id="verify-btn" class="btn" style="background-color:rgba(207, 166, 110, 1); color: #fff;">Verify OTP</button>
                
            </div>
        </form>
    </div>
</section>

<script>
        if (!/^\d{6}$/.test(otp)) {
            document.getElementById("error-container").textContent = "OTP must be 6 digits.";
            return;
        }

        document.addEventListener("DOMContentLoaded", function () {
            let countdown = 30;
            const countdownElement = document.getElementById("countdown");
            const resendButton = document.getElementById("resend-btn");
            const email = "<?php echo $_SESSION['email'] ?? ''; ?>"; // Email from PHP session

            function startCountdown() {
                resendButton.disabled = true;
                countdown = 30;
                countdownElement.textContent = countdown;

                const timer = setInterval(() => {
                    countdown--;
                    countdownElement.textContent = countdown;
                    if (countdown <= 0) {
                        clearInterval(timer);
                        resendButton.disabled = false;
                    }
                }, 1000);
            }

            // Start initial countdown
            startCountdown();

            // Handle Resend OTP click
            resendButton.addEventListener("click", function () {
                resendButton.disabled = true;
                startCountdown();

                // Send POST request with email
                fetch("resend_otp.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json"
                    },
                    body: JSON.stringify({ email: email })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === "success") {
                        alert("OTP has been resent to your email.");
                    } else {
                        alert("Error: " + data.message);
                    }
                })
                .catch(error => {
                    console.error("Error resending OTP:", error);
                    alert("An error occurred while resending the OTP.");
                });
            });
        });
</script>


<script>
        document.getElementById("otp-form").addEventListener("submit", function(e) {
            e.preventDefault();

            const otp = document.getElementById("floatingInputOtp").value.trim();
            const email = "<?php echo $_SESSION['email'] ?? ''; ?>"; // Assuming email is stored in session

            // Clear previous messages
            document.getElementById("error-container").textContent = "";
            document.getElementById("success-container").textContent = "";

            if (!otp || !email) {
                document.getElementById("error-container").textContent = "OTP or Email is missing.";
                return;
            }

            fetch("https://errandly.org/errandly/verify_otp.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json"
                },
                body: JSON.stringify({ otp: otp, email: email })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === "success") {
                    document.getElementById("success-container").textContent = data.message;

                    // ✅ Redirect to login after short delay
                    setTimeout(() => {
                        window.location.href = "login.php";
                    }, 1500);
                } else {
                    document.getElementById("error-container").textContent = data.message;
                }
            })
            .catch(error => {
                console.error("Error verifying OTP:", error);
                document.getElementById("error-container").textContent = "An error occurred. Try again.";
            });
        });
</script>



<?php include 'layout/footer.php'; ?>
