<?php
require_once 'conn.php';
header('Content-Type: application/json');

// Only allow PUT
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// Extract token
$authHeader = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}
$token = $matches[1];

// Decode input
$data = json_decode(file_get_contents('php://input'), true);
if (empty($data['user_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'User ID is required.']);
    exit();
}
$user_id = mysqli_real_escape_string($con, $data['user_id']);

// Validate token and user_id match
$auth_check = $con->query("SELECT user_id FROM users WHERE auth_token = '$token' AND user_id = '$user_id'");
if (!$auth_check || $auth_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized.']);
    exit();
}

// Build update fields
$fields = [];
if (isset($data['name']))     $fields[] = "name = '" . mysqli_real_escape_string($con, $data['name']) . "'";
if (isset($data['phone']))    $fields[] = "phone = '" . mysqli_real_escape_string($con, $data['phone']) . "'";
if (isset($data['address']))  $fields[] = "address = '" . mysqli_real_escape_string($con, $data['address']) . "'";
if (isset($data['dob']))      $fields[] = "dob = '" . mysqli_real_escape_string($con, $data['dob']) . "'";

// Update if any fields
if (!empty($fields)) {
    $update_sql = "UPDATE users SET " . implode(', ', $fields) . " WHERE user_id = '$user_id'";
    if (!$con->query($update_sql)) {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to update user.']);
        exit();
    }
}

// Fetch only necessary fields
$query = $con->query("SELECT id, user_id, name, email, phone, address, role, status, dob, wallet, user_image, is_verified, kyc_status, kyc_submitted, acct_name, acct_num FROM users WHERE user_id = '$user_id'");
if ($query && $query->num_rows > 0) {
    $user = $query->fetch_assoc();

    // Format response
    $response = [
        'id' => $user['id'],
        'user_id' => $user['user_id'],
        'name' => $user['name'],
        'email' => $user['email'],
        'phone' => $user['phone'],
        'wallet' => $user['wallet'],
        'role' => $user['role'],
        'status' => $user['status'],
        'dob' => $user['dob'],
        'address' => $user['address'], 
        'is_verified' => $user['is_verified'],
        'kyc_status' => isset($user['kyc_status']) ? $user['kyc_status'] : '',
        'kyc_submitted' => isset($user['kyc_submitted']) ? $user['kyc_submitted'] : '',
        'acct_name' => isset($user['acct_name']) ? $user['acct_name'] : '',
        'acct_num' => isset($user['acct_num']) ? $user['acct_num'] : '',
        'user_image' => 'https://errandly.org/errandly/uploads/user/' . ($user['user_image'] ?: 'placeholder.png'),
    ];

    echo json_encode([
        'status' => 'success',
        'message' => 'User updated successfully.',
        'user' => $response
    ]);
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'User not found after update.']);
}
?>
