<?php
require_once 'conn.php'; // Database connection
header('Content-Type: application/json');

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// Get input
$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['email']) || empty($data['password'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields.']);
    exit();
}

$email = mysqli_real_escape_string($con, $data['email']);
$password = mysqli_real_escape_string($con, $data['password']);

// Validate email format
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid email address.']);
    exit();
}

// Check user
$query = $con->query("SELECT * FROM users WHERE email = '$email' AND password = '$password'");

if ($query && $query->num_rows > 0) {
    $user = $query->fetch_assoc();

    // ✅ Check if account is deleted
    if ($user['status'] === 'deleted') {
        http_response_code(403);
        echo json_encode(['status' => 'error', 'message' => 'This account has been deleted. Contact support if needed.']);
        exit();
    }

    // Generate token
    $token = bin2hex(random_bytes(32));
    $con->query("UPDATE users SET auth_token = '$token' WHERE id = {$user['id']}");

    // ✅ Update login_detail table
    $user_id = $user['user_id'];
    $con->query("UPDATE login_detail SET log_status = 'online', last_activity = NOW() WHERE user_id = '$user_id'");

    $userData = [
        'id' => $user['id'],
        'user_id' => $user['user_id'],
        'name' => $user['name'],
        'email' => $user['email'],
        'phone' => $user['phone'],
        'wallet' => $user['wallet'],
        'role' => $user['role'],
        'status' => $user['status'],
        'dob' => $user['dob'],
        'address' => $user['address'], 
        'is_verified' => $user['is_verified'],
        'kyc_status' => $user['kyc_status'],
        'kyc_submitted' => $user['kyc_submitted'],
        'acct_name' => $user['acct_name'],
        'acct_num' => $user['acct_num'],
        'user_image' => 'https://errandly.org/errandly/uploads/user/' . ($user['user_image'] ?: 'placeholder.png'),
    ];

    header("Authorization: Bearer $token");

    echo json_encode([
        'status' => 'success',
        'message' => 'Login successful.',
        'token' => $token,
        'user' => $userData
    ]);
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid email or password.']);
}
?>
