<?php
require_once 'conn.php';
header('Content-Type: application/json');
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

// Token validation
$headers = apache_request_headers();
$authHeader = $headers['Authorization'] ?? '';

if ($authHeader && preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $token = $matches[1];
    $tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");

    if (!$tokenQuery || $tokenQuery->num_rows === 0) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
        exit();
    }

    $user = $tokenQuery->fetch_assoc();
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

// Ensure POST method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// Validate input
if (!isset($_FILES['image'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Image is required.']);
    exit();
}
// Validate input
if (!isset($_POST['user_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'user ID is required.']);
    exit();
}

$user_id = mysqli_real_escape_string($con, $_POST['user_id']);
$image = $_FILES['image'];

// Ensure token's user_id matches posted user_id
if ($user['user_id'] !== $user_id) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized user ID.']);
    exit();
}

// Validate image type
$allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/webp'];

if (!in_array($image['type'], $allowedTypes)) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid image type: ' . $image['type']
    ]);
    exit();
}


// Prepare image file
$ext = pathinfo($image['name'], PATHINFO_EXTENSION);
$newFileName = $user_id . '_' . time() . '.' . $ext;
$uploadDir = 'uploads/user/';
$uploadPath = $uploadDir . $newFileName;
$imageUrl = 'https://errandly.org/errandly/' . $uploadPath;

// Ensure folder exists
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// Upload file and update DB
if (move_uploaded_file($image['tmp_name'], $uploadPath)) {
    $update = $con->query("UPDATE users SET user_image = '$newFileName' WHERE user_id = '$user_id'");

    if ($update) {
        $updatedUser = $con->query("SELECT * FROM users WHERE user_id = '$user_id'")->fetch_assoc();
        $updatedUser['user_image'] = $imageUrl;

        echo json_encode([
            'status' => 'success',
            'message' => 'Image uploaded successfully.',
            'user' => [
                'id' => $user['id'],
                'user_id' => $user['user_id'],
                'name' => $user['name'],
                'email' => $user['email'],
                'phone' => $user['phone'],
                'wallet' => $user['wallet'],
                'role' => $user['role'],
                'status' => $user['status'],
                'dob' => $user['dob'],
                'is_verified' => $user['is_verified'],
                'address' => $user['address'], 
                'kyc_status' => $user['kyc_status'],
                'kyc_submitted' => $user['kyc_submitted'],
                'acct_name' => $user['acct_name'],
                'acct_num' => $user['acct_num'],
                'user_image' => $updatedUser['user_image'] ? $imageUrl : 'https://errandly.org/errandly/uploads/user/placeholder.png',
                'token' => $token
                
            ]
        ]);
    } else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to update user image.']);
    }
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to upload image.']);
}
?>
