<?php
require_once 'conn.php';
header('Content-Type: application/json');

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Extract Bearer Token from header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Authenticate user ---
$user_check = $con->query("SELECT user_id FROM users WHERE auth_token = '$token'");
if (!$user_check || $user_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}
$user_row = $user_check->fetch_assoc();
$user_id = $user_row['user_id'];

// --- Collect POST and FILE data ---
$home_address = $_POST['home_address'] ?? '';
$gov_id_type = $_POST['gov_id_type'] ?? '';
$nepa_bill_file = $_FILES['nepa_bill'] ?? null;
$gov_id_file = $_FILES['gov_id_file'] ?? null;

if (!$home_address || !$gov_id_type || !$nepa_bill_file || !$gov_id_file) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'All fields and files are required.']);
    exit();
}

// --- Generate unique KYC ID ---
function generateKYCID($length = 6) {
    return 'KYC_' . strtoupper(bin2hex(random_bytes($length / 2)));
}
$kyc_id = generateKYCID();

// --- Handle file uploads ---
$upload_dir = 'uploads/kyc/';
if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

function safeUpload($file, $upload_dir) {
    $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
    $unique_name = uniqid('kyc_', true) . '.' . $ext;
    $target_path = $upload_dir . $unique_name;
    return move_uploaded_file($file['tmp_name'], $target_path) ? $target_path : false;
}

$nepa_bill_path = safeUpload($nepa_bill_file, $upload_dir);
$gov_id_path = safeUpload($gov_id_file, $upload_dir);

if (!$nepa_bill_path || !$gov_id_path) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'File upload failed.']);
    exit();
}

// --- Save to database ---
$kyc_status = 'pending';

$stmt = $con->prepare("INSERT INTO user_kyc (kyc_id, user_id, home_address, nepa_bill, gov_id_type, gov_id_file, kyc_status) VALUES (?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("sssssss", $kyc_id, $user_id, $home_address, $nepa_bill_path, $gov_id_type, $gov_id_path, $kyc_status);

if ($stmt->execute()) {
    $fetch = $con->query("SELECT * FROM user_kyc WHERE kyc_id = '$kyc_id'");
    $kyc_data = $fetch->fetch_assoc();

    echo json_encode([
        'status' => 'success',
        'message' => 'KYC submitted successfully.',
        'kyc' => $kyc_data
    ]);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Database error.', 'error' => $stmt->error]);
}
?>
