<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'conn.php';

header('Content-Type: application/json');

// Only allow PUT
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Extract Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$user_check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$user_check || $user_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// $user = $user_check->fetch_assoc();
// if ($user['role'] !== 'admin') { // Optional: restrict to admins
//     http_response_code(403);
//     echo json_encode(['status' => 'error', 'message' => 'Forbidden. Admin access required.']);
//     exit();
// }

// --- Parse PUT input ---
$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['subcat_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Subcategory ID is required.']);
    exit();
}

$subcat_id = mysqli_real_escape_string($con, $data['subcat_id']);

$fields = [];

if (!empty($data['name'])) {
    $name = mysqli_real_escape_string($con, $data['name']);
    $fields[] = "name = '$name'";
}
if (!empty($data['slug'])) {
    $slug = mysqli_real_escape_string($con, $data['slug']);
    $fields[] = "slug = '$slug'";
}
if (!empty($data['cat_id'])) {
    $cat_id = mysqli_real_escape_string($con, $data['cat_id']);
    $fields[] = "cat_id = '$cat_id'";
}

$fields[] = "update_at = NOW()";

if (!empty($fields)) {
    $fields_sql = implode(', ', $fields);
    $update_sql = "UPDATE subcat SET $fields_sql WHERE subcat_id = '$subcat_id'";

    if (!$con->query($update_sql)) {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to update subcategory.', 'error' => $con->error]);
        exit();
    }
}

$result = $con->query("SELECT * FROM subcat WHERE subcat_id = '$subcat_id'");
if ($result && $result->num_rows > 0) {
    $subcat = $result->fetch_assoc();
    echo json_encode([
        'status' => 'success',
        'message' => 'Subcategory updated successfully.',
        'subcategory' => $subcat
    ]);
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Subcategory not found after update.']);
}
?>
