<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'conn.php';
header('Content-Type: application/json');

// Only allow PUT request
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Extract Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$user_check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$user_check || $user_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// Decode input JSON
$data = json_decode(file_get_contents("php://input"), true);

// Check required fields
if (empty($data['user_id']) || empty($data['kyc_status'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'user_id and kyc_status are required.']);
    exit();
}

$user_id = mysqli_real_escape_string($con, $data['user_id']);
$kyc_status = mysqli_real_escape_string($con, $data['kyc_status']);

// Update kyc_status
$update = $con->query("UPDATE user_kyc SET kyc_status = '$kyc_status' WHERE user_id = '$user_id'");

if ($update) {
    $result = $con->query("SELECT * FROM user_kyc WHERE user_id = '$user_id'");
    if ($result && $result->num_rows > 0) {
        $kyc = $result->fetch_assoc();
        echo json_encode([
            'status' => 'success',
            'message' => 'KYC status updated successfully.',
            'kyc' => $kyc
        ]);
    } else {
        http_response_code(404);
        echo json_encode(['status' => 'error', 'message' => 'KYC record not found.']);
    }
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to update KYC status.', 'error' => $con->error]);
}
?>
