<?php
require_once 'conn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

header('Content-Type: application/json');

// Get Authorization header
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader && preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $token = $matches[1];
    $userQuery = $con->query("SELECT user_id, email, full_name FROM users WHERE auth_token = '$token'");

    if (!$userQuery || $userQuery->num_rows === 0) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Invalid token']);
        exit();
    }

    $user = $userQuery->fetch_assoc();
    $user_id = $user['user_id'];
    $user_email = $user['email'];
    $user_name = $user['full_name'];
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header']);
    exit();
}

// Allow only PUT
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only PUT method is allowed']);
    exit();
}

// Parse JSON body
$data = json_decode(file_get_contents("php://input"), true);

// Validate required field
if (empty($data['book_hotel_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'book_hotel_id is required']);
    exit();
}

$book_hotel_id = $con->real_escape_string($data['book_hotel_id']);
$call_link = isset($data['call_link']) ? $con->real_escape_string($data['call_link']) : null;
$note = isset($data['note']) ? $con->real_escape_string($data['note']) : null;
$status = isset($data['status']) ? $con->real_escape_string($data['status']) : null;

// Confirm booking belongs to user
$check = $con->query("SELECT * FROM hotel_bookings WHERE book_hotel_id = '$book_hotel_id' AND user_id = '$user_id'");
if ($check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Booking not found or unauthorized']);
    exit();
}

// Build dynamic SQL
$updates = [];
if ($call_link !== null) $updates[] = "call_link = '$call_link'";
if ($note !== null) $updates[] = "note = '$note'";
if ($status !== null) $updates[] = "status = '$status'";

if (empty($updates)) {
    echo json_encode(['status' => 'error', 'message' => 'Nothing to update']);
    exit();
}

$updateQuery = "UPDATE hotel_bookings SET " . implode(", ", $updates) . " WHERE book_hotel_id = '$book_hotel_id' AND user_id = '$user_id'";

if ($con->query($updateQuery)) {

    // Send update notification email
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($user_email, $user_name);

        $mail->isHTML(true);
        $mail->Subject = 'Your Hotel Booking Has Been Updated';
        $mail->Body = "
            <h3>Hi {$user_name},</h3>
            <p>Your hotel booking <strong>{$book_hotel_id}</strong> has been updated.</p>
            <ul>
                " . ($call_link ? "<li><strong>Call Link:</strong> {$call_link}</li>" : "") . "
                " . ($note ? "<li><strong>Note:</strong> {$note}</li>" : "") . "
                " . ($status ? "<li><strong>Status:</strong> {$status}</li>" : "") . "
            </ul>
            <p>Thank you for using Errandly.</p>
        ";

        $mail->send();
    } catch (Exception $e) {
        error_log("Email sending failed: " . $mail->ErrorInfo);
    }

    echo json_encode(['status' => 'success', 'message' => 'Booking updated and email sent']);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to update booking', 'error' => $con->error]);
}
?>
