<?php
require_once 'conn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

header('Content-Type: application/json');

// Authorization Header
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or invalid Authorization token']);
    exit;
}

$token = $matches[1];
$userRes = $con->query("SELECT user_id, full_name, email FROM users WHERE auth_token = '$token'");

if (!$userRes || $userRes->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token']);
    exit;
}

$user = $userRes->fetch_assoc();
$user_id = $user['user_id'];
$user_name = $user['full_name'];
$user_email = $user['email'];

// Ensure method is PUT
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only PUT requests allowed']);
    exit;
}

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);

// Validate input
if (empty($data['book_hotel_id']) || empty($data['status'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Missing book_hotel_id or status']);
    exit;
}

$book_hotel_id = $con->real_escape_string($data['book_hotel_id']);
$status = $con->real_escape_string($data['status']);

// Check ownership
$bookingCheck = $con->query("SELECT * FROM hotel_bookings WHERE book_hotel_id = '$book_hotel_id' AND user_id = '$user_id'");
if ($bookingCheck->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized or booking not found']);
    exit;
}

// Update status
$update = $con->query("UPDATE hotel_bookings SET status = '$status' WHERE book_hotel_id = '$book_hotel_id' AND user_id = '$user_id'");
if ($update) {
    // Optional Email Notification
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($user_email, $user_name);

        $mail->isHTML(true);
        $mail->Subject = 'Booking Status Updated';
        $mail->Body = "
            <p>Hi {$user_name},</p>
            <p>Your booking <strong>#{$book_hotel_id}</strong> status has been updated to <strong>{$status}</strong>.</p>
            <p>– Team Errandly</p>
        ";
        $mail->send();
    } catch (Exception $e) {
        error_log("Email error: " . $mail->ErrorInfo);
    }

    echo json_encode(['status' => 'success', 'message' => 'Status updated']);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to update status', 'error' => $con->error]);
}
?>
