<?php
require_once 'conn.php'; // DB connection

// Token validation (optional for this endpoint)
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader) {
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $token = $matches[1];

        $tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
        if (!$tokenQuery || $tokenQuery->num_rows === 0) {
            http_response_code(401);
            echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
            exit();
        }

        // Optionally, you can extract the user info from here:
        // $user = $tokenQuery->fetch_assoc();
    } else {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Malformed Authorization header.']);
        exit();
    }
}


header('Content-Type: application/json');

// Allow only PUT request
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// Read JSON input
$data = json_decode(file_get_contents('php://input'), true);

// Check if cat_id is present
if (empty($data['cat_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Category ID (cat_id) is required.']);
    exit();
}

$cat_id = mysqli_real_escape_string($con, $data['cat_id']);
$fields = [];

// Optional fields to update
if (!empty($data['name'])) {
    $name = mysqli_real_escape_string($con, $data['name']);
    $fields[] = "name = '$name'";
}
if (!empty($data['slug'])) {
    $slug = mysqli_real_escape_string($con, $data['slug']);
    $fields[] = "slug = '$slug'";
}
if (!empty($data['icon'])) {
    $icon = mysqli_real_escape_string($con, $data['icon']);
    $fields[] = "icon = '$icon'";
}

// Update timestamp
$updated_at = date('Y-m-d H:i:s');
$fields[] = "updated_at = '$updated_at'";

// If no fields to update
if (empty($fields)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'No data provided to update.']);
    exit();
}

// Build update query
$fields_sql = implode(', ', $fields);
$update_sql = "UPDATE categories SET $fields_sql WHERE cat_id = '$cat_id'";

// Execute update
if ($con->query($update_sql)) {
    // Return the updated record
    $result = $con->query("SELECT * FROM categories WHERE cat_id = '$cat_id'");
    if ($result && $result->num_rows > 0) {
        $category = $result->fetch_assoc();

        // ✅ Get user token if user_id exists in category table (you may need to add this field)
        if (isset($category['user_id'])) {
            $user_id = $category['user_id'];
            $userRes = $con->query("SELECT auth_token FROM users WHERE user_id = '$user_id'");
            if ($userRes && $userRes->num_rows > 0) {
                $user = $userRes->fetch_assoc();
                if (!empty($user['auth_token'])) {
                    header("Authorization: Bearer {$user['auth_token']}");
                }
            }
        }

        echo json_encode([
            'status' => 'success',
            'message' => 'Category updated successfully.',
            'category' => $category
        ]);
    } else {
        http_response_code(404);
        echo json_encode(['status' => 'error', 'message' => 'Category not found after update.']);
    }
} else {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update category.',
        'error' => $con->error
    ]);
}
?>
