<?php
require_once 'conn.php';
header('Content-Type: application/json');

// --- 1. Check request method ---
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method. Use PUT.']);
    exit();
}

// --- 2. Token validation ---
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}

$token = $matches[1];
$userQuery = $con->query("SELECT user_id FROM users WHERE auth_token = '$token'");
if (!$userQuery || $userQuery->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized.']);
    exit();
}
$user_id = $userQuery->fetch_assoc()['user_id'];

// --- 3. Read and validate input ---
$data = json_decode(file_get_contents("php://input"), true);
$product_id = isset($data['product_id']) ? mysqli_real_escape_string($con, $data['product_id']) : '';
$quantity = isset($data['quantity']) ? (int)$data['quantity'] : 0;

if (!$product_id || $quantity < 1) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Product ID and valid quantity are required.']);
    exit();
}

// --- 4. Update cart quantity ---
$update = $con->query("UPDATE cart SET quantity = '$quantity' WHERE user_id = '$user_id' AND product_id = '$product_id'");

if ($update) {
    echo json_encode(['status' => 'success', 'message' => 'Cart updated successfully.']);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to update cart.', 'error' => $con->error]);
}
?>
