<?php
require_once 'conn.php';
header('Content-Type: application/json');

// Authorization (optional but handled)
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader && preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $token = $matches[1];
    $tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
    if (!$tokenQuery || $tokenQuery->num_rows === 0) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
        exit();
    }
} elseif ($authHeader) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Malformed Authorization header.']);
    exit();
}

// Use POST (not PUT) due to multipart/form-data
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed for updating with image.']);
    exit();
}

// Required: business_id
if (empty($_POST['business_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'business_id is required']);
    exit();
}

$business_id = $con->real_escape_string($_POST['business_id']);

// Prevent updating created_at
unset($_POST['created_at']);

$fields = [];

if (!empty($_POST['business_name'])) {
    $fields[] = "business_name = '" . $con->real_escape_string($_POST['business_name']) . "'";
}
if (!empty($_POST['business_email'])) {
    $fields[] = "business_email = '" . $con->real_escape_string($_POST['business_email']) . "'";
}
if (!empty($_POST['business_phone'])) {
    $fields[] = "business_phone = '" . $con->real_escape_string($_POST['business_phone']) . "'";
}
if (!empty($_POST['rc_number'])) {
    $fields[] = "rc_number = '" . $con->real_escape_string($_POST['rc_number']) . "'";
}
if (!empty($_POST['tax_id'])) {
    $fields[] = "tax_id = '" . $con->real_escape_string($_POST['tax_id']) . "'";
}
if (!empty($_POST['business_type'])) {
    $fields[] = "business_type = '" . $con->real_escape_string($_POST['business_type']) . "'";
}

// Optional: business image
if (isset($_FILES['business_img']) && $_FILES['business_img']['error'] === UPLOAD_ERR_OK) {
    $uploadDir = 'uploads/business/';
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    $imageTmp  = $_FILES['business_img']['tmp_name'];
    $imageName = uniqid() . '_' . basename($_FILES['business_img']['name']);
    $imagePath = $uploadDir . $imageName;

    if (move_uploaded_file($imageTmp, $imagePath)) {
        $fields[] = "business_img = '" . $con->real_escape_string($imageName) . "'";
    } else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to upload business image.']);
        exit();
    }
}

if (empty($fields)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'No valid fields to update']);
    exit();
}

$updateQuery = "UPDATE business_profiles SET " . implode(', ', $fields) . " WHERE business_id = '$business_id'";

if ($con->query($updateQuery)) {
    $result = $con->query("SELECT * FROM business_profiles WHERE business_id = '$business_id'");
    $updated = $result->fetch_assoc();

    echo json_encode([
        'status' => 'success',
        'message' => 'Business profile updated successfully',
        'data' => $updated
    ]);
} else {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update business profile',
        'error' => $con->error
    ]);
}
?>
