<?php
require_once 'conn.php';
header('Content-Type: application/json');
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

// 🔐 Token authentication
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or invalid token']);
    exit();
}
$token = $matches[1];

// ✅ Get request data
$data = json_decode(file_get_contents("php://input"), true);
$user_id = mysqli_real_escape_string($con, $data['user_id'] ?? '');
$pickup = mysqli_real_escape_string($con, $data['pickup_address'] ?? '');
$delivery = mysqli_real_escape_string($con, $data['delivery_address'] ?? '');
$fee = floatval($data['delivery_fee'] ?? 0);
$sender_name = mysqli_real_escape_string($con, $data['sender_name'] ?? '');
$sender_phone = mysqli_real_escape_string($con, $data['sender_phone'] ?? '');
$sender_email = mysqli_real_escape_string($con, $data['sender_email'] ?? '');
$receiver_name = mysqli_real_escape_string($con, $data['receiver_name'] ?? '');
$receiver_phone = mysqli_real_escape_string($con, $data['receiver_phone'] ?? '');
$receiver_email = mysqli_real_escape_string($con, $data['receiver_email'] ?? '');
$package_content = mysqli_real_escape_string($con, implode(',', $data['package_content'] ?? []));
$package_note = mysqli_real_escape_string($con, $data['package_note'] ?? '');
$del_status = 'processing'; // default
$delivery_type = mysqli_real_escape_string($con, $data['delivery_type'] ?? 'normal');
$fragility = mysqli_real_escape_string($con, $data['fragility'] ?? 'Not Fragile');
$created_at = $updated_at = date('Y-m-d H:i:s');

// ✅ Validate token belongs to user_id
$userQuery = $con->query("SELECT name FROM users WHERE auth_token = '$token' AND user_id = '$user_id'");
if (!$userQuery || $userQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Token does not match user_id.']);
    exit();
}
$userData = $userQuery->fetch_assoc();
$user_name = $userData['name'];

// 🔢 Generate package_id
$package_id = mysqli_real_escape_string($con, uniqid('ErrandlyPKG'));

// 📦 Insert into DB
$insert = $con->query("
    INSERT INTO package_deliveries (
        package_id, user_id, pickup_address, delivery_address, delivery_fee,
        sender_name, sender_phone, sender_email,
        receiver_name, receiver_phone, receiver_email,
        package_content, package_note, del_status, delivery_type,
        fragility, created_at, updated_at
    ) VALUES (
        '$package_id', '$user_id', '$pickup', '$delivery', '$fee',
        '$sender_name', '$sender_phone', '$sender_email',
        '$receiver_name', '$receiver_phone', '$receiver_email',
        '$package_content', '$package_note', '$del_status', '$delivery_type',
        '$fragility', '$created_at', '$updated_at'
    )
");

if ($insert) {
    $fetch = $con->query("SELECT * FROM package_deliveries WHERE package_id = '$package_id' LIMIT 1");
    $packageData = $fetch->fetch_assoc();

    // ✉️ Send status email
    sendStatusEmailToSender($sender_email, $sender_name, $package_id, $del_status);

    echo json_encode([
        'status' => 'success',
        'message' => 'Package request submitted',
        'package' => $packageData
    ]);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $con->error]);
}

// 📧 Email sender
function sendStatusEmailToSender($email, $name, $package_id, $status) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($email, $name);
        $mail->isHTML(true);
        $mail->Subject = "Package Submission - $package_id";
        $mail->Body = "
            Hi $name,<br><br>
            Your package <strong>$package_id</strong> is currently being <strong>$status</strong>.<br>
            We’ll notify you with updates.<br><br>
            Thanks for choosing <strong>Errandly</strong>!
        ";

        $mail->send();
    } catch (Exception $e) {
        // Optionally log: $e->getMessage()
    }
}
?>
