<?php
require_once 'conn.php';
header('Content-Type: application/json');

// 🔐 Step 1: Check Authorization token
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing or invalid.']);
    exit();
}
$token = $matches[1];

// 🔍 Step 2: Validate token
$tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$tokenQuery || $tokenQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}
$authUser = $tokenQuery->fetch_assoc();

// ✅ Step 3: Get input
$data = json_decode(file_get_contents("php://input"), true);
$otp = trim($data['otp'] ?? '');
$new_password = trim($data['new_password'] ?? '');
$confirm_password = trim($data['confirm_password'] ?? '');

if (empty($otp) || empty($new_password) || empty($confirm_password)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'OTP, new password, and confirm password are required']);
    exit();
}

if ($new_password !== $confirm_password) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Passwords do not match']);
    exit();
}

// Step 4: Fetch user by OTP (must match the token’s user too)
$query = $con->query("SELECT user_id, pwd_reset_expiry FROM users WHERE otp = '$otp' AND user_id = '{$authUser['user_id']}' LIMIT 1");

if (!$query || $query->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Invalid OTP']);
    exit();
}

$user = $query->fetch_assoc();

// Step 5: Check OTP expiry
if (strtotime($user['pwd_reset_expiry']) < time()) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'OTP has expired']);
    exit();
}

// Step 6: Update password (you can hash it if needed)
$con->query("UPDATE users SET password = '$new_password', otp = NULL, pwd_reset_expiry = NULL WHERE user_id = '{$user['user_id']}'");

echo json_encode(['status' => 'success', 'message' => 'Password reset successful']);
?>
