<?php
require_once 'conn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

header('Content-Type: application/json');

// Generate random OTP
function generateOTP($length = 6) {
    return rand(pow(10, $length-1), pow(10, $length)-1);
}

// Send OTP email
function sendOtpEmail($email, $name, $otp) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($email, $name);
        $mail->isHTML(true);
        $mail->Subject = 'Resend OTP - Email Verification';
        $mail->Body = "Hi $name,<br><br>Your OTP for email verification is: <strong>$otp</strong><br><br>Please use this to complete your verification.";

        $mail->send();
        return true;
    } catch (Exception $e) {
        return false;
    }
}

// POST method only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// Get and validate input
$data = json_decode(file_get_contents('php://input'), true);
if (empty($data['email'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Email is required.']);
    exit();
}

$email = mysqli_real_escape_string($con, $data['email']);

// Check if user exists
$query = $con->query("SELECT * FROM users WHERE email = '$email'");
if ($query && $query->num_rows === 1) {
    $user = $query->fetch_assoc();

    // if ($user['is_verified'] === '1') {
    //     echo json_encode(['status' => 'info', 'message' => 'Email already verified.']);
    //     exit();
    // }

    // Generate new OTP and update
    $otp = generateOTP();
    $update = $con->query("UPDATE users SET otp = '$otp' WHERE email = '$email'");

    if ($update && sendOtpEmail($email, $user['name'], $otp)) {
        echo json_encode(['status' => 'success', 'message' => 'OTP resent successfully. Please check your email.']);
    } else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to resend OTP.']);
    }
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'User not found.']);
}
?>
