<?php
header('Content-Type: application/json');
require_once 'conn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

// 🔐 Step 1: Get Authorization Token
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing or invalid.']);
    exit();
}
$token = $matches[1];

// Step 2: Verify token exists in the users table
$userTokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$userTokenQuery || $userTokenQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid or expired token.']);
    exit();
}

// Step 3: Parse request data
$data = json_decode(file_get_contents("php://input"), true);
$email = isset($data['email']) ? trim($data['email']) : '';

if (empty($email)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Email is required']);
    exit();
}

// Step 4: Check if email exists
$result = $con->query("SELECT user_id, name FROM users WHERE email = '$email'");
if (!$result || $result->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    exit();
}

// Step 5: Generate and save OTP
$user = $result->fetch_assoc();
$user_id = $user['user_id'];
$full_name = $user['name'];
$otp = rand(100000, 999999);
$expiry = date('Y-m-d H:i:s', strtotime('+15 minutes'));

$con->query("UPDATE users SET otp = '$otp', pwd_reset_expiry = '$expiry' WHERE user_id = '$user_id'");

// Step 6: Send OTP via email
$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host = 'mail.errandly.org';
    $mail->SMTPAuth = true;
    $mail->Username = 'info@errandly.org';
    $mail->Password = 'Zuo$cZs5}^7!';
    $mail->SMTPSecure = 'ssl';
    $mail->Port = 465;

    $mail->setFrom('info@errandly.org', 'Errandly');
    $mail->addAddress($email, $full_name);
    $mail->isHTML(true);
    $mail->Subject = 'Your Password Reset OTP';
    $mail->Body = "
        <h3>Hello {$full_name},</h3>
        <p>Use the OTP below to reset your password. It will expire in 15 minutes:</p>
        <h2>{$otp}</h2>
        <p>If you did not request this, please ignore this email.</p>
    ";

    $mail->send();
    echo json_encode(['status' => 'success', 'message' => 'OTP sent to your email']);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to send OTP email']);
}
?>
