<?php
require_once 'conn.php';
header('Content-Type: application/json');

// --- Token validation ---
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}

$token = $matches[1];
$userQuery = $con->query("SELECT user_id FROM users WHERE auth_token = '$token'");
if (!$userQuery || $userQuery->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized.']);
    exit();
}
$user_id = $userQuery->fetch_assoc()['user_id'];

// --- Input ---
$data = json_decode(file_get_contents("php://input"), true);
$product_id = isset($data['product_id']) ? mysqli_real_escape_string($con, $data['product_id']) : '';

if (!$product_id) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Product ID is required.']);
    exit();
}

// --- Delete from cart ---
$delete = $con->query("DELETE FROM cart WHERE user_id = '$user_id' AND product_id = '$product_id'");

if ($delete) {
    echo json_encode(['status' => 'success', 'message' => 'Product removed from cart.']);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to remove item.', 'error' => $con->error]);
}
?>
