<?php
require_once 'conn.php';
 ini_set('display_errors', 1); 
 ini_set('display_startup_errors', 1);
 error_reporting(E_ALL);
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

header('Content-Type: application/json');

function sendVerificationEmail($userEmail, $userName, $otp) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($userEmail);

        $mail->isHTML(true);
        $mail->Subject = 'Email Verification - Errandly';
        $mail->Body = "Hi $userName,<br><br>Your OTP for verifying your email is: <b>$otp</b><br><br>Please enter this OTP in the app to verify your email.";

        $mail->send();
        return true;
    } catch (Exception $e) {
        return false;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (!isset($data['name'], $data['email'], $data['password'], $data['phone'], $data['dob'], $data['address'])) {
        echo json_encode(['status' => 'error', 'message' => 'Missing required fields.']);
        exit();
    }

    $name = mysqli_real_escape_string($con, $data['name']);
    $email = mysqli_real_escape_string($con, $data['email']);
    $raw_password = mysqli_real_escape_string($con, $data['password']);
    $phone = mysqli_real_escape_string($con, $data['phone']);
    $dob = mysqli_real_escape_string($con, $data['dob']);
    $address = mysqli_real_escape_string($con, $data['address']);

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Invalid email address.']);
        exit();
    }

    if (!preg_match("/^[0-9]{10,15}$/", $phone)) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Invalid phone number.']);
        exit();
    }

    if (!preg_match("/^\d{4}-\d{2}-\d{2}$/", $dob)) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Invalid date format. Use YYYY-MM-DD.']);
        exit();
    }

    // ✅ Age check
    $dobDate = new DateTime($dob);
    $today = new DateTime();
    $age = $today->diff($dobDate)->y;
    if ($age < 12) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'You must be at least 12 years old to register.']);
        exit();
    }

    if (strlen($raw_password) <= 4) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Password must be more than 4 characters.']);
        exit();
    }

    $password = $raw_password;
    $role = 0;
    $user_id = 'errandlyuser' . uniqid();
    $otp = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);

    $check = $con->query("SELECT * FROM users WHERE email = '$email'");
    if ($check && $check->num_rows > 0) {
        http_response_code(409);
        echo json_encode(['status' => 'error', 'message' => 'Email already exists.']);
        exit();
    }

    $insert = $con->query("INSERT INTO users (user_id, name, email, password, phone, dob, address, otp, is_verified) 
        VALUES ('$user_id', '$name', '$email', '$password', '$phone', '$dob', '$address', '$otp', '0')");

    if ($insert) {
        sendVerificationEmail($email, $name, $otp);
        $_SESSION['email'] = $email;

        $imageFile = 'placeholder.png';
        $imageUrl = 'https://errandly.org/errandly/uploads/user/' . $imageFile;

        http_response_code(201);
        echo json_encode([
            'status' => 'success',
            'message' => 'Registration successful. OTP sent for email verification.',
            'user' => [
                'user_id' => $user_id,
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'dob' => $dob,
                'address' => $address,
                'user_image' => $imageUrl
                
            ]
        ]);
    } else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to register user.']);
    }
} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>
