<?php
require_once 'conn.php';
header('Content-Type: application/json');

// --- 1. Check request method ---
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method. Use POST.']);
    exit();
}

// --- Token validation ---
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}

$token = $matches[1];
$userResult = $con->query("SELECT user_id FROM users WHERE auth_token = '$token'");
if (!$userResult || $userResult->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized.']);
    exit();
}
$user_id = $userResult->fetch_assoc()['user_id'];

// --- Get delivery info ---
$data = json_decode(file_get_contents("php://input"), true);
$name = mysqli_real_escape_string($con, $data['name'] ?? '');
$email = mysqli_real_escape_string($con, $data['email'] ?? '');
$phone = mysqli_real_escape_string($con, $data['phone'] ?? '');
$city = mysqli_real_escape_string($con, $data['city'] ?? '');
$address = mysqli_real_escape_string($con, $data['address'] ?? '');
$note = mysqli_real_escape_string($con, $data['note'] ?? ''); // optional

if (!$name || !$email || !$phone || !$city || !$address) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Delivery info (name, email, phone, city, address) is required.']);
    exit();
}

// --- Fetch cart items ---
$cartResult = $con->query("SELECT c.*, p.price FROM cart c JOIN products p ON c.product_id = p.product_id WHERE c.user_id = '$user_id'");
if ($cartResult->num_rows === 0) {
    echo json_encode(['status' => 'error', 'message' => 'Cart is empty.']);
    exit();
}

// --- Create order ID ---
$order_id = 'ORD_' . strtoupper(bin2hex(random_bytes(5)));
$total_amount = 0;
$order_items = [];

while ($item = $cartResult->fetch_assoc()) {
    $product_id = $item['product_id'];
    $quantity = $item['quantity'];
    $price = $item['price'];
    $subtotal = $quantity * $price;
    $total_amount += $subtotal;

    $order_items[] = "('$order_id', '$user_id', '$product_id', '$quantity', '$price', '$subtotal')";
}

// --- Insert into orders table ---
$insertOrder = $con->query("INSERT INTO orders (
    order_id, user_id, total_amount, order_date,
    name, email, phone, city, address, note
) VALUES (
    '$order_id', '$user_id', '$total_amount', NOW(),
    '$name', '$email', '$phone', '$city', '$address', '$note'
)");

if (!$insertOrder) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to create order.', 'error' => $con->error]);
    exit();
}

// --- Insert into order_items table ---
$itemsQuery = "INSERT INTO order_items (order_id, user_id, product_id, quantity, price, subtotal) VALUES " . implode(',', $order_items);
if (!$con->query($itemsQuery)) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to add order items.', 'error' => $con->error]);
    exit();
}

// --- Clear cart after placing order ---
$con->query("DELETE FROM cart WHERE user_id = '$user_id'");

echo json_encode(['status' => 'success', 'message' => 'Order placed successfully.', 'order_id' => $order_id]);
?>
