<?php
require_once 'conn.php';
header("Content-Type: application/json");
header("Access-Control-Allow-Headers: Authorization");

// Get the Authorization header
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token not provided or malformed.']);
    exit();
}

$token = $matches[1];

// Find user with this token
$query = $con->query("SELECT * FROM users WHERE auth_token = '$token'");

if ($query && $query->num_rows > 0) {
    $user = $query->fetch_assoc();
    $user_id = $user['user_id'];

    // Clear the token
    $con->query("UPDATE users SET auth_token = NULL WHERE id = {$user['id']}");

    // Update login_detail table
    $con->query("UPDATE login_detail SET log_status = 'offline', last_activity = NOW() WHERE user_id = '$user_id'");

    echo json_encode(['status' => 'success', 'message' => 'Logged out successfully.']);
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid or expired token.']);
}
?>
