<?php
require_once 'conn.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit();
}

// --- Extract Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$user_check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$user_check || $user_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// --- Get JSON input ---
$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['cat_id']) || !isset($data['name']) || !isset($data['slug'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'cat_id, name, and slug are required.']);
    exit();
}

// --- Sanitize input ---
$cat_id = mysqli_real_escape_string($con, $data['cat_id']);
$name = mysqli_real_escape_string($con, $data['name']);
$slug = mysqli_real_escape_string($con, $data['slug']);
$created_at = date('Y-m-d H:i:s');

// --- Generate unique subcat_id ---
$subcat_id = 'errandlysubcat_' . time();

// --- Insert subcategory ---
$sql = "INSERT INTO subcat (subcat_id, cat_id, name, slug, created_at)
        VALUES ('$subcat_id', '$cat_id', '$name', '$slug', '$created_at')";

if ($con->query($sql)) {
    $result = $con->query("SELECT * FROM subcat WHERE subcat_id = '$subcat_id'");
    $subcategory = $result->fetch_assoc();

    echo json_encode(['status' => 'success', 'message' => 'Subcategory added successfully.', 'subcategory' => $subcategory]);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Database insert failed.', 'error' => $con->error]);
}
?>
