<?php
include 'conn.php';
header('Content-Type: application/json');

// Allow only POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
    exit();
}

// --- Extract Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$user_check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$user_check || $user_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// Get JSON data
$data = json_decode(file_get_contents("php://input"), true);

// Validate input
if (empty($data['user_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'user_id is required']);
    exit();
}

$user_id = $con->real_escape_string($data['user_id']);

// Update user role to rider
$update = $con->query("UPDATE users SET role = 'rider' WHERE user_id = '$user_id'");

if ($update && $con->affected_rows > 0) {
    // Fetch updated user
    $result = $con->query("SELECT * FROM users WHERE user_id = '$user_id'");
    
    if ($result && $result->num_rows > 0) {
        $user = $result->fetch_assoc();
        echo json_encode([
            'status' => 'success',
            'message' => 'User updated to rider successfully',
            'data' => $user
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'User updated but not found for fetch']);
    }
} else {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update user role or user not found',
        'error' => $con->error
    ]);
}
?>
