<?php
require_once 'conn.php'; // Your DB connection

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Extract Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$user_check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$user_check || $user_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// Get JSON input
$data = json_decode(file_get_contents('php://input'), true);

// Validate required fields
if (empty($data['name']) || empty($data['slug']) || empty($data['icon'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields.']);
    exit();
}

// Sanitize input
$name = mysqli_real_escape_string($con, $data['name']);
$slug = mysqli_real_escape_string($con, $data['slug']);
$icon = mysqli_real_escape_string($con, $data['icon']);
$cat_id = 'errandlycat_' . time();
$created_at = date('Y-m-d H:i:s');
$updated_at = $created_at;

// Insert into database
$sql = "INSERT INTO categories (cat_id, name, slug, icon, created_at, updated_at)
        VALUES ('$cat_id', '$name', '$slug', '$icon', '$created_at', '$updated_at')";

if ($con->query($sql)) {
    $id = $con->insert_id;

    // Fetch the inserted record
    $result = $con->query("SELECT * FROM categories WHERE id = $id");
    if ($result && $result->num_rows > 0) {
        $category = $result->fetch_assoc();
        echo json_encode([
            'status' => 'success',
            'message' => 'Category created successfully.',
            'category' => $category
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to fetch category after insert.']);
    }
} else {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to insert category.',
        'error' => $con->error
    ]);
}
?>
