<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'conn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

// Token validation
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader) {
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $token = $matches[1];

        $tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
        if (!$tokenQuery || $tokenQuery->num_rows === 0) {
            http_response_code(401);
            echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
            exit();
        }
    } else {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Malformed Authorization header.']);
        exit();
    }
}

// Use form-data, not raw JSON
$inputData = $_POST;

// Required fields
$requiredFields = ['user_id', 'business_name', 'business_email', 'business_phone', 'business_location', 'rc_number', 'tax_id', 'business_type', 'address'];
foreach ($requiredFields as $field) {
    if (empty($inputData[$field])) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => "$field is required."]);
        exit();
    }
}

$user_id        = mysqli_real_escape_string($con, $inputData['user_id']);
$business_name  = mysqli_real_escape_string($con, $inputData['business_name']);
$business_email  = mysqli_real_escape_string($con, $inputData['business_email']);
$business_phone  = mysqli_real_escape_string($con, $inputData['business_phone']);
$business_location  = mysqli_real_escape_string($con, $inputData['business_location']);
$rc_number      = mysqli_real_escape_string($con, $inputData['rc_number']);
$tax_id         = mysqli_real_escape_string($con, $inputData['tax_id']);
$business_type  = mysqli_real_escape_string($con, $inputData['business_type']);
$address        = mysqli_real_escape_string($con, $inputData['address']);
$business_email = isset($inputData['business_email']) ? mysqli_real_escape_string($con, $inputData['business_email']) : null;
$business_phone = isset($inputData['business_phone']) ? mysqli_real_escape_string($con, $inputData['business_phone']) : null;
$created_at     = date("Y-m-d H:i:s");

// Check if user already has a profile
$checkUserQuery = $con->query("SELECT * FROM business_profiles WHERE user_id = '$user_id'");
if ($checkUserQuery && $checkUserQuery->num_rows > 0) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'User already has an existing business profile.']);
    exit();
}

// Handle image upload
$business_img = null;
if (isset($_FILES['business_img']) && $_FILES['business_img']['error'] === UPLOAD_ERR_OK) {
    $uploadDir = 'uploads/business/';
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    $imageTmp  = $_FILES['business_img']['tmp_name'];
    $imageName = uniqid() . '_' . basename($_FILES['business_img']['name']);
    $imagePath = $uploadDir . $imageName;

    if (move_uploaded_file($imageTmp, $imagePath)) {
        $business_img = $imageName;
    } else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to upload business image.']);
        exit();
    }
}

// Generate custom business_id
$timestamp = time();
$randomString = strtoupper(bin2hex(random_bytes(4)));
$business_id = "BIZ-" . $timestamp . "-" . $randomString;

// Insert into DB
$sql = "INSERT INTO business_profiles (
    business_id, user_id, business_name, rc_number, tax_id, business_type,
    address, business_email, business_phone, business_img, created_at
) VALUES (
    '$business_id', '$user_id', '$business_name', '$rc_number', '$tax_id', '$business_type',
    '$address', " . ($business_email ? "'$business_email'" : "NULL") . ",
    " . ($business_phone ? "'$business_phone'" : "NULL") . ",
    " . ($business_img ? "'$business_img'" : "NULL") . ",
    '$created_at'
)";

if ($con->query($sql)) {
    $res = $con->query("SELECT * FROM business_profiles WHERE business_id = '$business_id'");
    $profile = $res->fetch_assoc();

        // Send confirmation email
        // Send confirmation email to business email
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'mail.errandly.org';
            $mail->SMTPAuth = true;
            $mail->Username = 'info@errandly.org';
            $mail->Password = 'Zuo$cZs5}^7!';
            $mail->SMTPSecure = 'ssl';
            $mail->Port = 465;
        
            $mail->setFrom('info@errandly.org', 'Errandly');
            $mail->addAddress($profile['business_email']); // ✅ Send to business email
            $mail->Subject = 'Business Profile Created';
            $mail->Body    = "Dear Business,\n\nYour business profile '{$profile['business_name']}' has been created successfully.\n\nThanks.";
        
            $mail->send();
        } catch (Exception $e) {
            error_log("Mailer Error: {$mail->ErrorInfo}");
        }


    $profile['business_img'] = $business_img ? 'https://errandly.org/errandly/uploads/business/' . $business_img : null;

    echo json_encode([
        'status' => 'success',
        'message' => 'Business profile created successfully.',
        'data' => $profile
    ]);

    } else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to create business profile.']);
}
?>
