<?php
// Check if the 'code' parameter is received
if (isset($_GET['code'])) {
    $authorizationCode = $_GET['code'];

    // Proceed with exchanging the code for an access token
    $accessToken = getAccessToken($authorizationCode);
    
    if ($accessToken) {
        // Return the access token in JSON format for Apidog testing
        echo json_encode([
            'access_token' => $accessToken,
            'status' => 'success'
        ]);
    } else {
        // Handle failure to exchange the code
        echo json_encode([
            'error' => 'Failed to exchange authorization code for access token',
            'status' => 'failure'
        ]);
    }
} else {
    // Handle case where 'code' parameter is missing
    echo json_encode([
        'error' => 'No authorization code received',
        'status' => 'failure'
    ]);
}

/**
 * Function to exchange authorization code for access token
 */
function getAccessToken($code) {
    // OAuth provider's token endpoint (Google OAuth in this case)
    $tokenUrl = 'https://oauth2.googleapis.com/token'; // Adjust if using another provider
    
    // OAuth credentials (use the actual credentials from your OAuth provider)
    $clientId = '134922654835-e7mhr1o8djqnu4kt3ccgdcomrk6nrrke.apps.googleusercontent.com';  // Replace with your OAuth client ID
    $clientSecret = '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'; // Replace with your OAuth client secret
    $redirectUri = 'http://localhost:8080/oauth2callback.php'; // Ensure this matches your registered redirect URI

    // Prepare POST data
    $postFields = [
        'code' => $code,
        'client_id' => $clientId,
        'client_secret' => $clientSecret,
        'redirect_uri' => $redirectUri,
        'grant_type' => 'authorization_code',
    ];

    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $tokenUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postFields));

    // Execute the cURL request
    $response = curl_exec($ch);
    
    // Check if cURL encountered any errors
    if (curl_errno($ch)) {
        // Return error in JSON format
        return json_encode([
            'error' => 'cURL Error: ' . curl_error($ch),
            'status' => 'failure'
        ]);
    }
    
    curl_close($ch);

    // Decode JSON response from OAuth provider
    $jsonResponse = json_decode($response, true);

    // Check if access token is present in the response
    if (isset($jsonResponse['access_token'])) {
        return $jsonResponse['access_token'];
    }

    return false;  // Return false if the access token isn't available
}
?>
