<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include 'conn.php';

header('Content-Type: application/json');

// --- Token Validation ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];
$tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");

if (!$tokenQuery || $tokenQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}

$authenticatedUser = $tokenQuery->fetch_assoc();

// --- Check if user_id is provided ---
if (!isset($_GET['user_id'])) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'user_id is required'
    ]);
    exit();
}

$user_id = $con->real_escape_string($_GET['user_id']);

// --- Ensure token owner matches requested user_id ---
if ($authenticatedUser['user_id'] !== $user_id) {
    http_response_code(403);
    echo json_encode([
        'status' => 'error',
        'message' => 'Access denied for this user_id.'
    ]);
    exit();
}

// --- Fetch user and KYC info ---
$sql = $con->query("
    SELECT u.*, k.kyc_status 
    FROM users u 
    LEFT JOIN user_kyc k ON u.user_id = k.user_id 
    WHERE u.user_id = '$user_id'
");

if ($sql && $sql->num_rows > 0) {
    $user = $sql->fetch_assoc();
    
    $user['user_image'] = 'https://errandly.org/errandly/uploads/user/' . ($user['user_image'] ?: 'placeholder.png');
    // Remove sensitive data
    unset($user['password']);
    unset($user['created_at']);
    unset($user['updated_at']);
    unset($user['reset_otp_expiry']);
    unset($user['temp_email']);
    unset($user['kyc_status']);
    unset($user['otp']);
    unset($user['business_profile_approve']);

    http_response_code(200);
    echo json_encode([
        'status' => 'success',
        'data' => $user,
        'token' => $user['auth_token'] ?? null
    ]);
} else {
    http_response_code(404);
    echo json_encode([
        'status' => 'error',
        'message' => 'User not found'
    ]);
}
?>
