<?php
require_once 'conn.php';
header('Content-Type: application/json');

// Allow only GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Extract Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$user_check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$user_check || $user_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// Retrieve input parameters from query string
$kyc_id = isset($_GET['kyc_id']) ? mysqli_real_escape_string($con, $_GET['kyc_id']) : null;
$user_id = isset($_GET['user_id']) ? mysqli_real_escape_string($con, $_GET['user_id']) : null;

// Validate input
if (empty($kyc_id) && empty($user_id)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'kyc_id or user_id is required.']);
    exit();
}

// Build query
if (!empty($kyc_id)) {
    $query = "SELECT * FROM user_kyc WHERE kyc_id = '$kyc_id'";
} else {
    $query = "SELECT * FROM user_kyc WHERE user_id = '$user_id'";
}

// Execute and fetch
$result = $con->query($query);
if ($result && $result->num_rows > 0) {
    $kyc_data = $result->fetch_assoc();
    echo json_encode(['status' => 'success', 'kyc' => $kyc_data]);
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'KYC record not found.']);
}
?>
