<?php
require_once 'conn.php';
header('Content-Type: application/json');

// 🔐 Get Authorization header
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token required']);
    exit();
}

$token = $matches[1];

// 🔐 Validate token
$tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$tokenQuery || $tokenQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid or expired token']);
    exit();
}

$authUser = $tokenQuery->fetch_assoc();

// ✅ Check if user_id is passed
if (!isset($_GET['user_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    exit();
}

$user_id = mysqli_real_escape_string($con, $_GET['user_id']);

// 🔍 Get user image
$result = $con->query("SELECT user_image FROM users WHERE user_id = '$user_id'");
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $image = $row['user_image'];
    
    if ($image && file_exists("uploads/user/" . $image)) {
        $image_url = "https://errandly.org/errandly/uploads/user/" . $image;
    } else {
        $image_url = "https://errandly.org/errandly/uploads/user/placeholder.png";
    }

    echo json_encode([
        'status' => 'success',
        'user_id' => $user_id,
        'image_url' => $image_url
    ]);
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
}
?>
