
<?php
require_once 'conn.php';
header('Content-Type: application/json');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Allow only GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only GET method is allowed']);
    exit();
}

// Check if user_id is provided
if (!isset($_GET['user_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'user_id is required']);
    exit();
}

$user_id = $con->real_escape_string($_GET['user_id']);

// Get user info
$userResult = $con->query("SELECT user_id, name, email FROM users WHERE user_id = '$user_id'");
if (!$userResult || $userResult->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    exit();
}
$user = $userResult->fetch_assoc();

// Get user bookings
$bookingResult = $con->query("SELECT * FROM hotel_bookings WHERE user_id = '$user_id' ORDER BY created_at DESC");

$bookings = [];
while ($row = $bookingResult->fetch_assoc()) {
    $bookings[] = [
        'book_hotel_id' => $row['book_hotel_id'],
        'call_link' => $row['call_link'],
        'note' => $row['note'],
        'status' => $row['status'],
        'created_at' => $row['created_at'],
    ];
}

echo json_encode([
    'status' => 'success',
    'message' => 'Bookings retrieved successfully',
    'user' => $user,
    'bookings' => $bookings
]);
?>
