<?php
require_once 'conn.php';
header('Content-Type: application/json');

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Extract Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$user_check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$user_check || $user_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// Check if subcat_id is set in the query string
if (!isset($_GET['subcat_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Subcategory ID is required.']);
    exit();
}

$subcat_id = mysqli_real_escape_string($con, $_GET['subcat_id']);

// Query the database
$sql = "SELECT * FROM subcat WHERE subcat_id = '$subcat_id'";
$result = $con->query($sql);

if ($result && $result->num_rows > 0) {
    $subcategory = $result->fetch_assoc();
    echo json_encode(['status' => 'success', 'subcategory' => $subcategory]);
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Subcategory not found.']);
}
?>
