<?php
include 'conn.php';
header('Content-Type: application/json');

// --- Check for GET method ---
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Extract Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$check || $check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// --- Check for rider ID ---
if (!isset($_GET['user_id']) || empty($_GET['user_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Rider ID is required.']);
    exit();
}

$user_id = mysqli_real_escape_string($con, $_GET['user_id']);

// --- Fetch single rider ---
$sql = $con->query("SELECT * FROM users WHERE user_id = '$user_id' AND role = 'rider'");

if ($sql && $sql->num_rows > 0) {
    $rider = $sql->fetch_assoc();

    echo json_encode([
        'status' => 'success',
        'data' => $rider
    ]);
} else {
    http_response_code(404);
    echo json_encode([
        'status' => 'error',
        'message' => 'Rider not found.'
    ]);
}
?>
