<?php
require_once 'conn.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

// 1. Token Check
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing or invalid.']);
    exit();
}

$token = $matches[1];
$tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$tokenQuery || $tokenQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}

// 2. Method Check
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// 3. Check for product_id in query params
if (!isset($_GET['product_id']) || empty($_GET['product_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Product ID is required.']);
    exit();
}

$product_id = mysqli_real_escape_string($con, $_GET['product_id']);

// 4. Fetch structured product data
$query = $con->query("
    SELECT 
        p.*,
        c.cat_id, c.name,
        s.subcat_id, s.name,
        b.business_id, b.business_name, b.business_email, b.business_phone,
        u.user_id, u.name, u.email AS user_email, u.phone AS user_phone
    FROM product p
    LEFT JOIN categories c ON p.cat_id = c.cat_id
    LEFT JOIN subcat s ON p.subcat_id = s.subcat_id
    LEFT JOIN business_profiles b ON p.business_id = b.business_id
    LEFT JOIN users u ON p.user_id = u.user_id
    WHERE p.product_id = '$product_id'
");

if ($query && $query->num_rows > 0) {
    $row = $query->fetch_assoc();

    // Structure the response
    $response = [
        'status' => 'success',
        'user' => [
            'user_id' => $row['user_id'],
            'full_name' => $row['name'],
            'email' => $row['user_email'],
            'phone' => $row['user_phone'],
            'business' => [
                'business_id' => $row['business_id'],
                'business_name' => $row['business_name'],
                'business_email' => $row['business_email'],
                'business_phone' => $row['business_phone'],
                'category' => [
                    'cat_id' => $row['cat_id'],
                    'cat_name' => $row['name'],
                    'subcategory' => [
                        'subcat_id' => $row['subcat_id'],
                        'subcat_name' => $row['name'],
                        'product' => [
                            'product_id' => $row['product_id'],
                            'name' => $row['name'],
                            'description' => $row['description'],
                            'price' => $row['price'],
                            'stock' => $row['stock'],
                            'prod_image1' => $row['prod_image1'],
                            'prod_image2' => $row['prod_image2'],
                            'product_image3' => $row['product_image3'],
                            'status' => $row['status'],
                            'prod_status' => $row['prod_status'],
                            'product_keyword' => $row['product_keyword'],
                            'delivery_date' => $row['delivery_date'],
                            'bonus' => $row['bonus'],
                            'prod_color' => $row['prod_color'],
                            'created_at' => $row['created_at'],
                            'updated_at' => $row['updated_at']
                        ]
                    ]
                ]
            ]
        ]
    ];

    echo json_encode($response);
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Product not found.']);
}
?>
