<?php
require_once 'conn.php'; // Include database connection

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Extract Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$user_check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$user_check || $user_check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// --- Proceed with fetching category ---
if (!isset($_GET['cat_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'cat_id is required.']);
    exit();
}

$cat_id = mysqli_real_escape_string($con, $_GET['cat_id']);

$query = "SELECT * FROM categories WHERE cat_id = '$cat_id'";
$result = $con->query($query);

if ($result && $result->num_rows > 0) {
    $category = $result->fetch_assoc();
    echo json_encode(['status' => 'success', 'category' => $category]);
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Category not found.']);
}
?>
