<?php
require_once 'conn.php';
header('Content-Type: application/json');

// Get Authorization header
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader && preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $token = $matches[1];
    $userQuery = $con->query("SELECT user_id FROM users WHERE auth_token = '$token'");

    if (!$userQuery || $userQuery->num_rows === 0) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Invalid token']);
        exit();
    }
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header']);
    exit();
}

// Check for GET and required param
if ($_SERVER['REQUEST_METHOD'] !== 'GET' || !isset($_GET['book_hotel_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Missing book_hotel_id or invalid method']);
    exit();
}

$booking_id = $con->real_escape_string($_GET['book_hotel_id']);

// Fetch the booking
$query = "
    SELECT hb.book_hotel_id, hb.call_link, hb.note, hb.status, hb.created_at,
           u.full_name AS user_name, u.email AS user_email
    FROM hotel_bookings hb
    JOIN users u ON hb.user_id = u.user_id
    WHERE hb.book_hotel_id = '$booking_id'
";

$result = $con->query($query);

if ($result && $result->num_rows > 0) {
    $booking = $result->fetch_assoc();
    echo json_encode(['status' => 'success', 'data' => $booking]);
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Booking not found']);
}
?>
