<?php
require_once 'conn.php'; // Database connection
header('Content-Type: application/json');

// --- Allow only GET requests ---
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Check Bearer Token in Authorization header ---
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// --- Validate token ---
$check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$check || $check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// --- Check if a specific cat_id is provided ---
if (isset($_GET['cat_id'])) {
    $cat_id = mysqli_real_escape_string($con, $_GET['cat_id']);
    $query = "SELECT * FROM categories WHERE cat_id = '$cat_id'";
    $result = $con->query($query);

    if ($result && $result->num_rows > 0) {
        $category = $result->fetch_assoc();
        echo json_encode(['status' => 'success', 'category' => $category]);
    } else {
        http_response_code(404);
        echo json_encode(['status' => 'error', 'message' => 'Category not found.']);
    }
} else {
    // --- Return all categories ---
    $query = "SELECT * FROM categories ORDER BY created_at DESC";
    $result = $con->query($query);

    $categories = [];
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }

    echo json_encode(['status' => 'success', 'categories' => $categories]);
}
?>
