<?php
require_once 'conn.php';
header('Content-Type: application/json');

// --- 1. Check request method ---
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method. Use GET.']);
    exit();
}

// --- Token validation ---
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or invalid token.']);
    exit();
}

$token = $matches[1];
$userQuery = $con->query("SELECT user_id FROM users WHERE auth_token = '$token'");
if (!$userQuery || $userQuery->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized.']);
    exit();
}
$user = $userQuery->fetch_assoc();
$user_id = $user['user_id'];

// --- Fetch cart items ---
$sql = $con->query("SELECT c.*, p.name, p.price, p.prod_image1 FROM cart c 
                   JOIN products p ON c.product_id = p.product_id 
                   WHERE c.user_id = '$user_id'");

$cart = [];
while ($row = $sql->fetch_assoc()) {
    $cart[] = $row;
}

echo json_encode(['status' => 'success', 'data' => $cart]);
?>
