<?php
require_once 'conn.php';
header('Content-Type: application/json');

// ✅ Allow only GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only GET method is allowed.']);
    exit();
}

// ✅ Check Bearer token in Authorization header
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// ✅ Validate token
$check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$check || $check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// ✅ Fetch all KYC records
$result = $con->query("SELECT * FROM user_kyc ORDER BY created_at DESC");

$kycList = [];
while ($row = $result->fetch_assoc()) {
    $kycList[] = $row;
}

echo json_encode([
    'status' => 'success',
    'kyc_records' => $kycList
]);
?>
