<?php
require_once 'conn.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');

// Token Check
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing or invalid.']);
    exit();
}

$token = $matches[1];
$tokenCheck = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$tokenCheck || $tokenCheck->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}

// Fetch joined data
$query = $con->query("
    SELECT 
        p.*, 
        c.cat_id, c.name AS category_name,
        s.subcat_id, s.name AS subcategory_name,
        b.business_id, b.business_name, b.business_email, b.business_phone,
        u.user_id, u.name AS user_name, u.email AS user_email, u.phone AS user_phone
    FROM product p
    LEFT JOIN categories c ON p.cat_id = c.cat_id
    LEFT JOIN subcat s ON p.subcat_id = s.subcat_id
    LEFT JOIN business_profiles b ON p.business_id = b.business_id
    LEFT JOIN users u ON p.user_id = u.user_id
    ORDER BY u.user_id, b.business_id, c.cat_id, s.subcat_id, p.created_at DESC
");

$structured = [];

if ($query && $query->num_rows > 0) {
    while ($row = $query->fetch_assoc()) {
        $user_id = $row['user_id'];
        $business_id = $row['business_id'];
        $cat_id = $row['cat_id'];
        $subcat_id = $row['subcat_id'];

        // Initialize user
        if (!isset($structured[$user_id])) {
            $structured[$user_id] = [
                'user_id' => $user_id,
                'name' => $row['user_name'],
                'email' => $row['user_email'],
                'phone' => $row['user_phone'],
                'businesses' => []
            ];
        }

        // Initialize business
        if (!isset($structured[$user_id]['businesses'][$business_id])) {
            $structured[$user_id]['businesses'][$business_id] = [
                'business_id' => $business_id,
                'business_name' => $row['business_name'],
                'business_email' => $row['business_email'],
                'business_phone' => $row['business_phone'],
                'categories' => []
            ];
        }

        // Initialize category
        if (!isset($structured[$user_id]['businesses'][$business_id]['categories'][$cat_id])) {
            $structured[$user_id]['businesses'][$business_id]['categories'][$cat_id] = [
                'cat_id' => $cat_id,
                'category_name' => $row['category_name'],
                'subcategories' => []
            ];
        }

        // Initialize subcategory
        if (!isset($structured[$user_id]['businesses'][$business_id]['categories'][$cat_id]['subcategories'][$subcat_id])) {
            $structured[$user_id]['businesses'][$business_id]['categories'][$cat_id]['subcategories'][$subcat_id] = [
                'subcat_id' => $subcat_id,
                'subcategory_name' => $row['subcategory_name'],
                'products' => []
            ];
        }

        // Add product
        $structured[$user_id]['businesses'][$business_id]['categories'][$cat_id]['subcategories'][$subcat_id]['products'][] = [
            'product_id' => $row['product_id'],
            'name' => $row['name'],
            'description' => $row['description'],
            'price' => $row['price'],
            'stock' => $row['stock'],
            'status' => $row['status'],
            'prod_image1' => $row['prod_image1'],
            'prod_image2' => $row['prod_image2'],
            'product_image3' => $row['product_image3'],
            'delivery_date' => $row['delivery_date'],
            'created_at' => $row['created_at']
        ];
    }

    // Format into indexed arrays for JSON
    $final = array_values(array_map(function ($user) {
        $user['businesses'] = array_values(array_map(function ($biz) {
            $biz['categories'] = array_values(array_map(function ($cat) {
                $cat['subcategories'] = array_values($cat['subcategories']);
                return $cat;
            }, $biz['categories']));
            return $biz;
        }, $user['businesses']));
        return $user;
    }, $structured));

    echo json_encode([
        'status' => 'success',
        'message' => 'Products retrieved successfully.',
        'data' => $final
    ]);
} else {
    echo json_encode([
        'status' => 'success',
        'message' => 'No products found.',
        'data' => []
    ]);
}
?>
