<?php
require_once 'conn.php';
header('Content-Type: application/json');

// Get Authorization header
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader && preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $token = $matches[1];
    $userQuery = $con->query("SELECT user_id FROM users WHERE auth_token = '$token'");

    if (!$userQuery || $userQuery->num_rows === 0) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Invalid token']);
        exit();
    }

    // Optional: You could check if user is admin here if needed
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header']);
    exit();
}

// Fetch all hotel bookings with user info
$query = "
    SELECT hb.book_hotel_id, hb.call_link, hb.note, hb.status, hb.created_at, 
           u.name AS user_name, u.email AS user_email, u.user_id AS user_id 
    FROM hotel_bookings hb
    JOIN users u ON hb.user_id = u.user_id
    ORDER BY hb.created_at DESC
";

$result = $con->query($query);

$bookings = [];
while ($row = $result->fetch_assoc()) {
    $bookings[] = $row;
}

echo json_encode([
    'status' => 'success',
    'data' => $bookings
]);
?>
