<?php
require_once 'conn.php';
header('Content-Type: application/json');
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

// 🔐 Token validation
$headers = apache_request_headers();
$authHeader = $headers['Authorization'] ?? '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}
$token = $matches[1];

// 🔍 Get user by token
$userQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$userQuery || $userQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}
$user = $userQuery->fetch_assoc();

// ✅ Check request method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// ✅ Validate user_id and match with token owner
if (!isset($_POST['user_id']) || $user['user_id'] !== $_POST['user_id']) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized or missing user_id.']);
    exit();
}
$user_id = mysqli_real_escape_string($con, $_POST['user_id']);

// ✅ Check for image
if (!isset($_FILES['image'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Image is required.']);
    exit();
}
$image = $_FILES['image'];

// ✅ Validate image type
$allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/webp'];
if (!in_array($image['type'], $allowedTypes)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid image type.']);
    exit();
}

// 🔄 Remove old image (if not placeholder)
$oldImage = $user['user_image'];
if ($oldImage && $oldImage !== 'placeholder.png') {
    $oldPath = __DIR__ . "/uploads/user/$oldImage";
    if (file_exists($oldPath)) {
        unlink($oldPath);
    }
}

// 📦 Upload new image
$ext = pathinfo($image['name'], PATHINFO_EXTENSION);
$newFileName = $user_id . '_' . time() . '.' . $ext;
$uploadDir = 'uploads/user/';
$uploadPath = $uploadDir . $newFileName;
$imageUrl = 'https://errandly.org/errandly/' . $uploadPath;

if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

if (move_uploaded_file($image['tmp_name'], $uploadPath)) {
    $con->query("UPDATE users SET user_image = '$newFileName' WHERE user_id = '$user_id'");

    $updatedUser = $con->query("SELECT * FROM users WHERE user_id = '$user_id'")->fetch_assoc();

    echo json_encode([
        'status' => 'success',
        'message' => 'Image uploaded successfully.',
        'user' => [
            'id' => $updatedUser['id'],
            'user_id' => $updatedUser['user_id'],
            'name' => $updatedUser['name'],
            'email' => $updatedUser['email'],
            'phone' => $updatedUser['phone'],
            'wallet' => $updatedUser['wallet'],
            'role' => $updatedUser['role'],
            'status' => $updatedUser['status'],
            'dob' => $updatedUser['dob'],
            'is_verified' => $updatedUser['is_verified'],
            'address' => $updatedUser['address'],
            'kyc_status' => $updatedUser['kyc_status'],
            'kyc_submitted' => $updatedUser['kyc_submitted'],
            'acct_name' => $updatedUser['acct_name'],
            'acct_num' => $updatedUser['acct_num'],
            'user_image' => $imageUrl,
            'token' => $token
        ]
    ]);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to upload image.']);
}
?>
