<?php
require_once 'conn.php'; // Database connection
header('Content-Type: application/json');

// Token validation
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader) {
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $token = $matches[1];

        $tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
        if (!$tokenQuery || $tokenQuery->num_rows === 0) {
            http_response_code(401);
            echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
            exit();
        }
    } else {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Malformed Authorization header.']);
        exit();
    }
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token is missing.']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['user_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'User ID is required.']);
    exit();
}

$user_id = mysqli_real_escape_string($con, $data['user_id']);

// Check if user exists
$check_user = $con->query("SELECT user_id FROM users WHERE user_id = '$user_id'");
if (!$check_user || $check_user->num_rows == 0) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'User not found.']);
    exit();
}

// Soft delete: mark status as 'deleted'
$update = $con->query("UPDATE users SET status = 'deleted' WHERE user_id = '$user_id'");

if ($update) {
    echo json_encode(['status' => 'success', 'message' => 'User marked as deleted.']);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to update user status.']);
}
?>
