<?php
require_once 'conn.php';
header('Content-Type: application/json');

// 🔐 Token authorization
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing or invalid.']);
    exit();
}
$token = $matches[1];

// 📥 Get user_id from request body
$data = json_decode(file_get_contents("php://input"), true);
$user_id = mysqli_real_escape_string($con, $data['user_id'] ?? '');

if (empty($user_id)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    exit();
}

// ✅ Validate token and user
$query = $con->query("SELECT * FROM users WHERE auth_token = '$token' AND user_id = '$user_id'");
// if (!$query || $query->num_rows === 0) {
//     http_response_code(403);
//     echo json_encode(['status' => 'error', 'message' => 'Unauthorized or user not found']);
//     exit();
// }

$user = $query->fetch_assoc();
$image = $user['user_image'];

// 📁 Delete image if it exists and is not placeholder
if (!empty($image) && $image !== 'placeholder.png') {
    $imagePath = __DIR__ . "/uploads/user/" . $image;
    if (file_exists($imagePath)) {
        unlink($imagePath); // delete the image file
    }
}

// ❌ Delete user record
$delete = $con->query("DELETE FROM users WHERE user_id = '$user_id'");

if ($delete) {
    echo json_encode(['status' => 'success', 'message' => 'User deleted successfully']);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to delete user']);
}
