<?php
require_once 'conn.php';
header('Content-Type: application/json');

// 🔐 Token authentication
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token required']);
    exit();
}

$token = $matches[1];

// 🔍 Validate token
$tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$tokenQuery || $tokenQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid or expired token']);
    exit();
}

$user = $tokenQuery->fetch_assoc();
$user_id = $user['user_id'];

// 🔍 Check if image exists
$getImage = $con->query("SELECT user_image FROM users WHERE user_id = '$user_id'");
if ($getImage && $getImage->num_rows > 0) {
    $row = $getImage->fetch_assoc();
    $filename = $row['user_image'];
    $filepath = "uploads/user/" . $filename;

    // 🧹 Delete file from server if it exists
    if (!empty($filename) && file_exists($filepath)) {
        unlink($filepath);
    }

    // 🧾 Update database
    $update = $con->query("UPDATE users SET user_image = NULL WHERE user_id = '$user_id'");

    if ($update) {
        echo json_encode([
            'status' => 'success',
            'message' => 'User image deleted successfully',
            'image_url' => 'https://errandly.org/errandly/uploads/user/placeholder.png'
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update user record.']);
    }
} else {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'User not found.']);
}
?>
