<?php
require_once 'conn.php'; // your DB connection file
header('Content-Type: application/json');

// Token validation
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader) {
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $token = $matches[1];

        $tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
        if (!$tokenQuery || $tokenQuery->num_rows === 0) {
            http_response_code(401);
            echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
            exit();
        }
        // Optional: $user = $tokenQuery->fetch_assoc();
    } else {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Malformed Authorization header.']);
        exit();
    }
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token is missing.']);
    exit();
}

// Only allow DELETE request
if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// Get the input data
$data = json_decode(file_get_contents("php://input"), true);

// Check if subcat_id is provided
if (empty($data['subcat_id'])) {
    http_response_code(400); // Bad Request
    echo json_encode(['status' => 'error', 'message' => 'Subcategory ID is required.']);
    exit();
}

$subcat_id = mysqli_real_escape_string($con, $data['subcat_id']);

// Attempt to delete the subcategory
$sql = "DELETE FROM subcat WHERE subcat_id = '$subcat_id'";
if ($con->query($sql)) {
    if ($con->affected_rows > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Subcategory deleted successfully.']);
    } else {
        http_response_code(404); // Not Found
        echo json_encode(['status' => 'error', 'message' => 'Subcategory not found.']);
    }
} else {
    http_response_code(500); // Server Error
    echo json_encode(['status' => 'error', 'message' => 'Delete failed.', 'error' => $con->error]);
}
?>
